﻿#===========================================================================
# GUI版 サンプルのビルド／実行 ツール
#
# ※このツールの起動には powershell Version 3.0 以上が必要です。
#===========================================================================
Add-Type -AssemblyName presentationframework

[xml]$loadXaml = @"
<Window xmlns="http://schemas.microsoft.com/winfx/2006/xaml/presentation"
        xmlns:x="http://schemas.microsoft.com/winfx/2006/xaml"
        Title="Eft テスト" Height="700" Width="625">

    <Window.Resources>
        <!-- 通常時のボタンの背景色 -->
        <SolidColorBrush x:Key="NormalBackgroundBrush64" Color="#D0DDDD"/>
        <!-- 通常時のボタンの背景色 -->
        <SolidColorBrush x:Key="NormalBackgroundBrushRef" Color="#DDDDD0"/>
        <!-- カスタムボタンのスタイル（64） -->
        <Style x:Key="ButtonStyle32" TargetType="{x:Type Button}">
            <Setter Property="Background" Value="{StaticResource NormalBackgroundBrush64}"/>
        </Style>
        <!-- カスタムボタンのスタイル（正解画像） -->
        <Style x:Key="ButtonStyleRef" TargetType="{x:Type Button}">
            <Setter Property="Background" Value="{StaticResource NormalBackgroundBrushRef}"/>
        </Style>
    </Window.Resources>

    <ScrollViewer HorizontalScrollBarVisibility="Auto">
        <StackPanel Orientation="Vertical" Margin="2">
            <GroupBox Header="全体管理" Margin="2">
                <StackPanel Orientation="Vertical">
                    <StackPanel Orientation="Horizontal">
                        <Button Name="allClear" Content="クリア" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="ビルドされた出力やキャプチャ結果をクリアします。(注)git clean -fdx Programs,Tests,Tools" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                    <StackPanel Orientation="Horizontal">
                        <Button Name="allBuild" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="全てのビルドを行います。" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                </StackPanel>
            </GroupBox>

            <!-- エスケープ文字には エンティティ参照を使う  -->
            <GroupBox Header="HostBridge IP アドレス（実機 IP アドレスが &quot;169.*&quot; 以外は必須）" Margin="2">
                <StackPanel Orientation="Vertical">
                    <TextBlock Name="TargetAddressPattern" Text="TARGET_ADDRESS_PATTERN="/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <TextBox Name="ip0" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="." HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBox Name="ip1" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="." HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBox Name="ip2" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="." HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBox Name="ip3" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                    <StackPanel Orientation="Horizontal">
                        <Button Name="setTargetAddressPattern" Content="設定" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="setEnvTargetAddressPattern" Content="環境変数に追加" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="resetEnvTargetAddressPattern" Content="環境変数から削除" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                </StackPanel>
            </GroupBox>

            <GroupBox Header="NX実機ツールの作成" Margin="2">
                <StackPanel Orientation="Vertical">
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="toolsBuild" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="NX(実機) を実行するには必須です。"/>
                    </StackPanel>
                </StackPanel>
            </GroupBox>

            <GroupBox Header="ScreenCaptureGfx" Margin="2">
                <StackPanel Orientation="Vertical">

                    <TextBlock Text="Win64"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="ScreencaptureWin64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureWin64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureWin64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureWin64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureWin64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(Win)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="ScreencaptureNXOnWin64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureNXOnWin64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureNXOnWin64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureNXOnWin64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureNXOnWin64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(実機) ※実行時に描画は行いません。"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="ScreencaptureNXFP2_a64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureNXFP2_a64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureNXFP2_a64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureNXFP2_a64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="ScreencaptureNXFP2_a64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="Win32"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="ScreencaptureWin32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="ScreencaptureWin32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="ScreencaptureWin32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX32(Win)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="ScreencaptureNXOnWin32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="ScreencaptureNXOnWin32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="ScreencaptureNXOnWin32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX32(実機) ※実行時に描画は行いません。"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="ScreencaptureNXFP2_a32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="ScreencaptureNXFP2_a32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="ScreencaptureNXFP2_a32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="プラットフォーム間で正解画像を比較"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyleRef}" Name="ScreencaptureRefimagesExecute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyleRef}" Name="ScreencaptureRefimagesResult" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="実行前に Win64 の ビルドが必要です。"/>
                    </StackPanel>

                </StackPanel>
            </GroupBox>

            <GroupBox Header="CheckDataComp" Margin="2">
                <StackPanel Orientation="Vertical">

                    <TextBlock Text="Win64"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="CheckdatacompWin64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompWin64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompWin64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompWin64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompWin64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(Win)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="CheckdatacompNXOnWin64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompNXOnWin64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompNXOnWin64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompNXOnWin64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompNXOnWin64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(実機) ※実行時に描画は行いません。"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="CheckdatacompNXFP2_a64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompNXFP2_a64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompNXFP2_a64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompNXFP2_a64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="CheckdatacompNXFP2_a64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="Win32"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="CheckdatacompWin32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="CheckdatacompWin32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="CheckdatacompWin32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX32(Win)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="CheckdatacompNXOnWin32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="CheckdatacompNXOnWin32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="CheckdatacompNXOnWin32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX32(実機) ※実行時に描画は行いません。"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="CheckdatacompNXFP2_a32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="CheckdatacompNXFP2_a32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="CheckdatacompNXFP2_a32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="プラットフォーム間で正解画像を比較"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyleRef}" Name="CheckdatacompRefimagesExecute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyleRef}" Name="CheckdatacompRefimagesResult" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="実行前に Win64 の ビルドが必要です。"/>
                    </StackPanel>

                </StackPanel>
            </GroupBox>

            <GroupBox Header="BinaryCompatibility" Margin="2">
                <StackPanel Orientation="Vertical">

                    <TextBlock Text="Win64"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="BinaryCompatibilityWin64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityWin64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityWin64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityWin64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityWin64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(Win)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="BinaryCompatibilityNXOnWin64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityNXOnWin64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityNXOnWin64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityNXOnWin64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityNXOnWin64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(実機) ※実行時に描画は行いません。"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="BinaryCompatibilityNXFP2_a64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityNXFP2_a64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityNXFP2_a64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityNXFP2_a64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="BinaryCompatibilityNXFP2_a64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="Win32"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="BinaryCompatibilityWin32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="BinaryCompatibilityWin32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="BinaryCompatibilityWin32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX32(Win)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="BinaryCompatibilityNXOnWin32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="BinaryCompatibilityNXOnWin32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="BinaryCompatibilityNXOnWin32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX32(実機) ※実行時に描画は行いません。"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="BinaryCompatibilityNXFP2_a32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="BinaryCompatibilityNXFP2_a32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="BinaryCompatibilityNXFP2_a32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                </StackPanel>
            </GroupBox>

        </StackPanel>
    </ScrollViewer>
</Window>
"@

# Windows7 等は標準が Version 2.0 の為、3 に満たない場合は起動しないようにする。
if($PSVersionTable.PSVersion.Major -lt 3){
   $message = "Powershellバージョン 3 以上が必要です。" + "現在のバージョンは " + $PSVersionTable.PSVersion.Major + " です。"
   Write-Output $message
   exit
}

# 多重ビルド抑止用のロックファイルが存在する場合は、起動時に削除を行う。
if (Test-Path Build/.lock)
{
	Remove-Item Build/.lock
}

$reader = New-Object System.Xml.XmlNodeReader $loadXaml
$window = [Windows.Markup.XamlReader]::Load($reader)

#===========================================================================
# 全体管理
#===========================================================================
$allClear   = $window.Findname("allClear");
$allBuild   = $window.Findname("allBuild");

$allClear.Add_Click({
   try
   {
      Start-Process -FilePath ".\Clean.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Clean.bat が見つかりません。")
   }
})
$allBuild.Add_Click({
   try {
      Start-Process -FilePath ".\Build_All.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build_All.bat が見つかりません。")
   }
})

#===========================================================================
# Tools
#===========================================================================
$toolsBuild = $window.Findname("toolsBuild");

$toolsBuild.Add_Click({
   try {
      Start-Process -FilePath ".\Build\Build_Tools.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_Tools.bat が見つかりません。")
   }
})

#===========================================================================
# ScreenCapture / win64
#===========================================================================
$ScreencaptureWin64Build     = $window.Findname("ScreencaptureWin64Build");
$ScreencaptureWin64Execute   = $window.Findname("ScreencaptureWin64Execute");
$ScreencaptureWin64Result    = $window.Findname("ScreencaptureWin64Result");
$ScreencaptureWin64Capture   = $window.Findname("ScreencaptureWin64Capture");
$ScreencaptureWin64Reference = $window.Findname("ScreencaptureWin64Reference");

$ScreencaptureWin64Build.Add_Click({
   try {
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_Win64.bat が見つかりません。")
   }
})
$ScreencaptureWin64Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-ScreenCaptureGfx-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-ScreenCaptureGfx-platform.Win64.bat が見つかりません。")
   }
})
$ScreencaptureWin64Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_ScreenCatureGfx_Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_ScreenCatureGfx_Win64.bat が見つかりません。")
   }
})
$ScreencaptureWin64Capture.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\x64-v140\ScreenCaptureGfx\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\x64-v140\ScreenCaptureGfx\captured が見つかりません。")
   }
})
$ScreencaptureWin64Reference.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\ScreenCapture\Vfx\Win64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\ScreenCapture\Vfx\Win64 が見つかりません。")
   }
})

#===========================================================================
# ScreenCapture / win32
#===========================================================================
$ScreencaptureWin32Build     = $window.Findname("ScreencaptureWin32Build");
$ScreencaptureWin32Execute   = $window.Findname("ScreencaptureWin32Execute");
$ScreencaptureWin32Result    = $window.Findname("ScreencaptureWin32Result");

$ScreencaptureWin32Build.Add_Click({
   try {
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_Win32.bat が見つかりません。")
   }
})
$ScreencaptureWin32Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-ScreenCaptureGfx-platform.Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-ScreenCaptureGfx-platform.Win32.bat が見つかりません。")
   }
})
$ScreencaptureWin32Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_ScreenCatureGfx_Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_ScreenCatureGfx_Win32.bat が見つかりません。")
   }
})

#===========================================================================
# ScreenCapture / NXOnWin64
#===========================================================================
$ScreencaptureNXOnWin64Build     = $window.Findname("ScreencaptureNXOnWin64Build");
$ScreencaptureNXOnWin64Execute   = $window.Findname("ScreencaptureNXOnWin64Execute");
$ScreencaptureNXOnWin64Result    = $window.Findname("ScreencaptureNXOnWin64Result");
$ScreencaptureNXOnWin64Capture   = $window.Findname("ScreencaptureNXOnWin64Capture");
$ScreencaptureNXOnWin64Reference = $window.Findname("ScreencaptureNXOnWin64Reference");

$ScreencaptureNXOnWin64Build.Add_Click({
   try {
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXOnWin64.bat が見つかりません。")
   }
})
$ScreencaptureNXOnWin64Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-ScreenCaptureGfx-platform.NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-ScreenCaptureGfx-platform.NXOnWin64.bat が見つかりません。")
   }
})
$ScreencaptureNXOnWin64Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_ScreenCatureGfx_NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_ScreenCatureGfx_NXOnWin64.bat が見つかりません。")
   }
})
$ScreencaptureNXOnWin64Capture.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-x64-v140\ScreenCaptureGfx\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-x64-v140\ScreenCaptureGfx\captured が見つかりません。")
   }
})
$ScreencaptureNXOnWin64Reference.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\ScreenCapture\Vfx\NXOnWin64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\ScreenCapture\Vfx\NXOnWin64 が見つかりません。")
   }
})

#===========================================================================
# ScreenCapture / NXOnWin32
#===========================================================================
$ScreencaptureNXOnWin32Build     = $window.Findname("ScreencaptureNXOnWin32Build");
$ScreencaptureNXOnWin32Execute   = $window.Findname("ScreencaptureNXOnWin32Execute");
$ScreencaptureNXOnWin32Result    = $window.Findname("ScreencaptureNXOnWin32Result");

$ScreencaptureNXOnWin32Build.Add_Click({
   try {
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXOnWin32.bat が見つかりません。")
   }
})
$ScreencaptureNXOnWin32Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-ScreenCaptureGfx-platform.NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-ScreenCaptureGfx-platform.NXOnWin32.bat が見つかりません。")
   }
})
$ScreencaptureNXOnWin32Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_ScreenCatureGfx_NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_ScreenCatureGfx_NXOnWin32.bat が見つかりません。")
   }
})

#===========================================================================
# ScreenCapture / NXFP2-a64
#===========================================================================
$ScreencaptureNXFP2_a64Build     = $window.Findname("ScreencaptureNXFP2_a64Build");
$ScreencaptureNXFP2_a64Execute   = $window.Findname("ScreencaptureNXFP2_a64Execute");
$ScreencaptureNXFP2_a64Result    = $window.Findname("ScreencaptureNXFP2_a64Result");
$ScreencaptureNXFP2_a64Capture   = $window.Findname("ScreencaptureNXFP2_a64Capture");
$ScreencaptureNXFP2_a64Reference = $window.Findname("ScreencaptureNXFP2_a64Reference");

$ScreencaptureNXFP2_a64Build.Add_Click({
   try {
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXFP2-a64.bat が見つかりません。")
   }
})
$ScreencaptureNXFP2_a64Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-ScreenCaptureGfx-platform.NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-ScreenCaptureGfx-platform.NXFP2-a64.bat が見つかりません。")
   }
})
$ScreencaptureNXFP2_a64Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_ScreenCatureGfx_NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_ScreenCatureGfx_NXFP2-a64.bat が見つかりません。")
   }
})
$ScreencaptureNXFP2_a64Capture.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-NXFP2-a64\ScreenCaptureGfx\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-NXFP2-a64\ScreenCaptureGfx\captured が見つかりません。")
   }
})
$ScreencaptureNXFP2_a64Reference.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\ScreenCapture\Vfx\NX-NXFP2-a64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\ScreenCapture\Vfx\NX-NXFP2-a64 が見つかりません。")
   }
})

#===========================================================================
# ScreenCapture / NXFP2-a32
#===========================================================================
$ScreencaptureNXFP2_a32Build     = $window.Findname("ScreencaptureNXFP2_a32Build");
$ScreencaptureNXFP2_a32Execute   = $window.Findname("ScreencaptureNXFP2_a32Execute");
$ScreencaptureNXFP2_a32Result    = $window.Findname("ScreencaptureNXFP2_a32Result");

$ScreencaptureNXFP2_a32Build.Add_Click({
   try {
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXFP2-a32.bat が見つかりません。")
   }
})
$ScreencaptureNXFP2_a32Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-ScreenCaptureGfx-platform.NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-ScreenCaptureGfx-platform.NXFP2-a32.bat が見つかりません。")
   }
})
$ScreencaptureNXFP2_a32Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_ScreenCatureGfx_NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_ScreenCatureGfx_NXFP2-a32.bat が見つかりません。")
   }
})

#===========================================================================
# ScreenCapture / 正解画像
#===========================================================================
$ScreencaptureRefimagesExecute   = $window.Findname("ScreencaptureRefimagesExecute");
$ScreencaptureRefimagesResult    = $window.Findname("ScreencaptureRefimagesResult");

$ScreencaptureRefimagesExecute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-CompareReferenceImages-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-CompareReferenceImages-platform.Win64.bat が見つかりません。")
   }
})
$ScreencaptureRefimagesResult.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_ScreenCaptureGfx-CompareReferenceImages.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_ScreenCaptureGfx-CompareReferenceImages.bat が見つかりません。")
   }
})

#===========================================================================
# Checkdatacomp / win64
#===========================================================================
$CheckdatacompWin64Build     = $window.Findname("CheckdatacompWin64Build");
$CheckdatacompWin64Execute   = $window.Findname("CheckdatacompWin64Execute");
$CheckdatacompWin64Result    = $window.Findname("CheckdatacompWin64Result");
$CheckdatacompWin64Capture   = $window.Findname("CheckdatacompWin64Capture");
$CheckdatacompWin64Reference = $window.Findname("CheckdatacompWin64Reference");

$CheckdatacompWin64Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_Win64.bat が見つかりません。")
   }
})
$CheckdatacompWin64Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-CheckDataComp-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-CheckDataComp-platform.Win64.bat が見つかりません。")
   }
})
$CheckdatacompWin64Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_CheckDataComp_Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_CheckDataComp_Win64.bat が見つかりません。")
   }
})
$CheckdatacompWin64Capture.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\x64-v140\CheckDataComp\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\x64-v140\CheckDataComp\captured が見つかりません。")
   }
})
$CheckdatacompWin64Reference.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\Vfx\Win64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\Vfx\Win64 が見つかりません。")
   }
})

#===========================================================================
# Checkdatacomp / win32
#===========================================================================
$CheckdatacompWin32Build     = $window.Findname("CheckdatacompWin32Build");
$CheckdatacompWin32Execute   = $window.Findname("CheckdatacompWin32Execute");
$CheckdatacompWin32Result    = $window.Findname("CheckdatacompWin32Result");

$CheckdatacompWin32Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_Win32.bat が見つかりません。")
   }
})
$CheckdatacompWin32Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-CheckDataComp-platform.Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-CheckDataComp-platform.Win32.bat が見つかりません。")
   }
})
$CheckdatacompWin32Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_CheckDataComp_Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_CheckDataComp_Win32.bat が見つかりません。")
   }
})

#===========================================================================
# Checkdatacomp / NXOnWin64
#===========================================================================
$CheckdatacompNXOnWin64Build     = $window.Findname("CheckdatacompNXOnWin64Build");
$CheckdatacompNXOnWin64Execute   = $window.Findname("CheckdatacompNXOnWin64Execute");
$CheckdatacompNXOnWin64Result    = $window.Findname("CheckdatacompNXOnWin64Result");
$CheckdatacompNXOnWin64Capture   = $window.Findname("CheckdatacompNXOnWin64Capture");
$CheckdatacompNXOnWin64Reference = $window.Findname("CheckdatacompNXOnWin64Reference");

$CheckdatacompNXOnWin64Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXOnWin64.bat が見つかりません。")
   }
})
$CheckdatacompNXOnWin64Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-CheckDataComp-platform.NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-CheckDataComp-platform.NXOnWin64.bat が見つかりません。")
   }
})
$CheckdatacompNXOnWin64Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_CheckDataComp_NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_CheckDataComp_NXOnWin64.bat が見つかりません。")
   }
})
$CheckdatacompNXOnWin64Capture.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-x64-v140\CheckDataComp\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-x64-v140\CheckDataComp\captured が見つかりません。")
   }
})
$CheckdatacompNXOnWin64Reference.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\Vfx\NXOnWin64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\Vfx\NXOnWin64 が見つかりません。")
   }
})

#===========================================================================
# Checkdatacomp / NXOnWin32
#===========================================================================
$CheckdatacompNXOnWin32Build     = $window.Findname("CheckdatacompNXOnWin32Build");
$CheckdatacompNXOnWin32Execute   = $window.Findname("CheckdatacompNXOnWin32Execute");
$CheckdatacompNXOnWin32Result    = $window.Findname("CheckdatacompNXOnWin32Result");

$CheckdatacompNXOnWin32Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXOnWin32.bat が見つかりません。")
   }
})
$CheckdatacompNXOnWin32Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-CheckDataComp-platform.NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-CheckDataComp-platform.NXOnWin32.bat が見つかりません。")
   }
})
$CheckdatacompNXOnWin32Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_CheckDataComp_NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_CheckDataComp_NXOnWin32.bat が見つかりません。")
   }
})

#===========================================================================
# Checkdatacomp / NXFP2-a64
#===========================================================================
$CheckdatacompNXFP2_a64Build     = $window.Findname("CheckdatacompNXFP2_a64Build");
$CheckdatacompNXFP2_a64Execute   = $window.Findname("CheckdatacompNXFP2_a64Execute");
$CheckdatacompNXFP2_a64Result    = $window.Findname("CheckdatacompNXFP2_a64Result");
$CheckdatacompNXFP2_a64Capture   = $window.Findname("CheckdatacompNXFP2_a64Capture");
$CheckdatacompNXFP2_a64Reference = $window.Findname("CheckdatacompNXFP2_a64Reference");

$CheckdatacompNXFP2_a64Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXFP2-a64.bat が見つかりません。")
   }
})
$CheckdatacompNXFP2_a64Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-CheckDataComp-platform.NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-CheckDataComp-platform.NXFP2-a64.bat が見つかりません。")
   }
})
$CheckdatacompNXFP2_a64Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_CheckDataComp_NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_CheckDataComp_NXFP2-a64.bat が見つかりません。")
   }
})
$CheckdatacompNXFP2_a64Capture.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-NXFP2-a64\CheckDataComp\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-NXFP2-a64\CheckDataComp\captured が見つかりません。")
   }
})
$CheckdatacompNXFP2_a64Reference.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\Vfx\NX-NXFP2-a64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\Vfx\NX-NXFP2-a64 が見つかりません。")
   }
})

#===========================================================================
# Checkdatacomp / NXFP2-a32
#===========================================================================
$CheckdatacompNXFP2_a32Build     = $window.Findname("CheckdatacompNXFP2_a32Build");
$CheckdatacompNXFP2_a32Execute   = $window.Findname("CheckdatacompNXFP2_a32Execute");
$CheckdatacompNXFP2_a32Result    = $window.Findname("CheckdatacompNXFP2_a32Result");

$CheckdatacompNXFP2_a32Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXFP2-a32.bat が見つかりません。")
   }
})
$CheckdatacompNXFP2_a32Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-CheckDataComp-platform.NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-CheckDataComp-platform.NXFP2-a32.bat が見つかりません。")
   }
})
$CheckdatacompNXFP2_a32Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_CheckDataComp_NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_CheckDataComp_NXFP2-a32.bat が見つかりません。")
   }
})

#===========================================================================
# Checkdatacomp / 正解画像
#===========================================================================
$CheckdatacompRefimagesExecute   = $window.Findname("CheckdatacompRefimagesExecute");
$CheckdatacompRefimagesResult    = $window.Findname("CheckdatacompRefimagesResult");

$CheckdatacompRefimagesExecute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-CheckDataComp-CompareReferenceImages-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-CheckDataComp-CompareReferenceImages-platform.Win64.bat が見つかりません。")
   }
})
$CheckdatacompRefimagesResult.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_CheckDataComp-CompareReferenceImages.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_CheckDataComp-CompareReferenceImages.bat が見つかりません。")
   }
})

#===========================================================================
# BinaryCompatibility / win64
#===========================================================================
$BinaryCompatibilityWin64Build     = $window.Findname("BinaryCompatibilityWin64Build");
$BinaryCompatibilityWin64Execute   = $window.Findname("BinaryCompatibilityWin64Execute");
$BinaryCompatibilityWin64Result    = $window.Findname("BinaryCompatibilityWin64Result");
$BinaryCompatibilityWin64Capture   = $window.Findname("BinaryCompatibilityWin64Capture");
$BinaryCompatibilityWin64Reference = $window.Findname("BinaryCompatibilityWin64Reference");

$BinaryCompatibilityWin64Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_Win64.bat が見つかりません。")
   }
})
$BinaryCompatibilityWin64Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-BinaryCompatibility-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-BinaryCompatibility-platform.Win64.bat が見つかりません。")
   }
})
$BinaryCompatibilityWin64Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_BinaryCompatibility_Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_BinaryCompatibility_Win64.bat が見つかりません。")
   }
})
$BinaryCompatibilityWin64Capture.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\x64-v140\BinaryCompatibility\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\x64-v140\BinaryCompatibility\captured が見つかりません。")
   }
})
$BinaryCompatibilityWin64Reference.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\NXAddon-3_2\Vfx\Win64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\NXAddon-3_2\Vfx\Win64 が見つかりません。")
   }
})

#===========================================================================
# BinaryCompatibility / win32
#===========================================================================
$BinaryCompatibilityWin32Build     = $window.Findname("BinaryCompatibilityWin32Build");
$BinaryCompatibilityWin32Execute   = $window.Findname("BinaryCompatibilityWin32Execute");
$BinaryCompatibilityWin32Result    = $window.Findname("BinaryCompatibilityWin32Result");

$BinaryCompatibilityWin32Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_Win32.bat が見つかりません。")
   }
})
$BinaryCompatibilityWin32Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-BinaryCompatibility-platform.Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-BinaryCompatibility-platform.Win32.bat が見つかりません。")
   }
})
$BinaryCompatibilityWin32Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_BinaryCompatibility_Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_BinaryCompatibility_Win32.bat が見つかりません。")
   }
})

#===========================================================================
# BinaryCompatibility / NXOnWin64
#===========================================================================
$BinaryCompatibilityNXOnWin64Build     = $window.Findname("BinaryCompatibilityNXOnWin64Build");
$BinaryCompatibilityNXOnWin64Execute   = $window.Findname("BinaryCompatibilityNXOnWin64Execute");
$BinaryCompatibilityNXOnWin64Result    = $window.Findname("BinaryCompatibilityNXOnWin64Result");
$BinaryCompatibilityNXOnWin64Capture   = $window.Findname("BinaryCompatibilityNXOnWin64Capture");
$BinaryCompatibilityNXOnWin64Reference = $window.Findname("BinaryCompatibilityNXOnWin64Reference");

$BinaryCompatibilityNXOnWin64Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXOnWin64.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXOnWin64Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-BinaryCompatibility-platform.NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-BinaryCompatibility-platform.NXOnWin64.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXOnWin64Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_BinaryCompatibility_NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_BinaryCompatibility_NXOnWin64.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXOnWin64Capture.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-x64-v140\BinaryCompatibility\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-x64-v140\BinaryCompatibility\captured が見つかりません。")
   }
})
$BinaryCompatibilityNXOnWin64Reference.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\NXAddon-3_2\Vfx\NXOnWin64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\NXAddon-3_2\Vfx\NXOnWin64 が見つかりません。")
   }
})

#===========================================================================
# BinaryCompatibility / NXOnWin32
#===========================================================================
$BinaryCompatibilityNXOnWin32Build     = $window.Findname("BinaryCompatibilityNXOnWin32Build");
$BinaryCompatibilityNXOnWin32Execute   = $window.Findname("BinaryCompatibilityNXOnWin32Execute");
$BinaryCompatibilityNXOnWin32Result    = $window.Findname("BinaryCompatibilityNXOnWin32Result");

$BinaryCompatibilityNXOnWin32Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXOnWin32.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXOnWin32Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-BinaryCompatibility-platform.NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-BinaryCompatibility-platform.NXOnWin32.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXOnWin32Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_BinaryCompatibility_NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_BinaryCompatibility_NXOnWin32.bat が見つかりません。")
   }
})

#===========================================================================
# BinaryCompatibility / NXFP2-a64
#===========================================================================
$BinaryCompatibilityNXFP2_a64Build     = $window.Findname("BinaryCompatibilityNXFP2_a64Build");
$BinaryCompatibilityNXFP2_a64Execute   = $window.Findname("BinaryCompatibilityNXFP2_a64Execute");
$BinaryCompatibilityNXFP2_a64Result    = $window.Findname("BinaryCompatibilityNXFP2_a64Result");
$BinaryCompatibilityNXFP2_a64Capture   = $window.Findname("BinaryCompatibilityNXFP2_a64Capture");
$BinaryCompatibilityNXFP2_a64Reference = $window.Findname("BinaryCompatibilityNXFP2_a64Reference");

$BinaryCompatibilityNXFP2_a64Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXFP2-a64.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXFP2_a64Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-BinaryCompatibility-platform.NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-BinaryCompatibility-platform.NXFP2-a64.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXFP2_a64Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_BinaryCompatibility_NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_BinaryCompatibility_NXFP2-a64.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXFP2_a64Capture.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-NXFP2-a64\BinaryCompatibility\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_ScreenCaptureGfx\NX-NXFP2-a64\BinaryCompatibility\captured が見つかりません。")
   }
})
$BinaryCompatibilityNXFP2_a64Reference.Add_Click({
   try {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\NXAddon-3_2\Vfx\NX-NXFP2-a64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\CheckDataComp\NXAddon-3_2\Vfx\NX-NXFP2-a64 が見つかりません。")
   }
})

#===========================================================================
# BinaryCompatibility / NXFP2-a32
#===========================================================================
$BinaryCompatibilityNXFP2_a32Build     = $window.Findname("BinaryCompatibilityNXFP2_a32Build");
$BinaryCompatibilityNXFP2_a32Execute   = $window.Findname("BinaryCompatibilityNXFP2_a32Execute");
$BinaryCompatibilityNXFP2_a32Result    = $window.Findname("BinaryCompatibilityNXFP2_a32Result");

$BinaryCompatibilityNXFP2_a32Build.Add_Click({
   try {
      # ScreenCaptureGfx と同じコマンドなので呼ぶバッチファイルも同一
      Start-Process -FilePath ".\Build\Build_ScreenCaptureGfx_NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_ScreenCaptureGfx_NXFP2-a32.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXFP2_a32Execute.Add_Click({
   try {
      Start-Process -FilePath ".\Execute\RunTest-BinaryCompatibility-platform.NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-BinaryCompatibility-platform.NXFP2-a32.bat が見つかりません。")
   }
})
$BinaryCompatibilityNXFP2_a32Result.Add_Click({
   try {
      Start-Process -FilePath ".\Result\Result_BinaryCompatibility_NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_BinaryCompatibility_NXFP2-a32.bat が見つかりません。")
   }
})

#===========================================================================
# TARGET_ADDRESS_PATTERN
#===========================================================================
$ip0        = $window.Findname("ip0");
$ip1        = $window.Findname("ip1");
$ip2        = $window.Findname("ip2");
$ip3        = $window.Findname("ip3");
$ta         = $window.Findname("TargetAddressPattern");
$setTa      = $window.Findname("setTargetAddressPattern");
$setEnvTa   = $window.Findname("setEnvTargetAddressPattern");
$resetEnvTa = $window.Findname("resetEnvTargetAddressPattern");

if (($env:TARGET_ADDRESS_PATTERN).Length -eq 0)
{
#   "undefined TARGET_ADDRESS_PATTERN"
}
else
{
   $targetAddressPattern = ($env:TARGET_ADDRESS_PATTERN);

   $ta.Text = "TARGET_ADDRESS_PATTERN=" + $targetAddressPattern;

   $ip = $targetAddressPattern.Split(".");
   $ip0.Text = $ip[0]
   $ip1.Text = $ip[1]
   $ip2.Text = $ip[2]
   $ip3.Text = $ip[3]
}

$setTa.Add_Click({
   $ip = $ip0.Text + "." + $ip1.Text + "." + $ip2.Text + "." + $ip3.Text;
   $ta.Text = "TARGET_ADDRESS_PATTERN=" + $ip;

   set-item env:TARGET_ADDRESS_PATTERN -value $ip
})
$setEnvTa.Add_Click({
   $ip = $ip0.Text + "." + $ip1.Text + "." + $ip2.Text + "." + $ip3.Text;
   $ta.Text = "TARGET_ADDRESS_PATTERN=" + $ip;

   set-item env:TARGET_ADDRESS_PATTERN -value $ip

   # 永続的に環境変数を設定する
   [Environment]::SetEnvironmentVariable("TARGET_ADDRESS_PATTERN", $ip, [EnvironmentVariableTarget]::User)
})
$resetEnvTa.Add_Click({
   $ta.Text = "TARGET_ADDRESS_PATTERN="

   set-item env:TARGET_ADDRESS_PATTERN -value ""

   # 永続的に環境変数を設定する
   [Environment]::SetEnvironmentVariable("TARGET_ADDRESS_PATTERN", $null, [EnvironmentVariableTarget]::User)
})

$result = $window.ShowDialog()
