﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once
#include "framework/testEft_EffectSystem.h"

namespace nnt{
namespace eft{

/**
 * @brief テストカスタムパラメータクラス
 *
 * @details テストカスタムパラメータ用クラスです。
 */
class TestCustomBehaviorParam
{
public:
    /**
     * @brief テストカスタム動作ユーザデータビット
     *
     */
    enum TestCustomBehaviorUserDataBit
    {
        TestCustomBehavior_UserDataBit_0  = 1<<0,        // Camera Y Z位置 注視点_Yの設定(固定)
        TestCustomBehavior_UserDataBit_1  = 1<<1,        // カメラ位置アニメ
        TestCustomBehavior_UserDataBit_2  = 1<<2,        // カメラタイプを「パースペクティブ」から「オルソ」に変更
        TestCustomBehavior_UserDataBit_3  = 1<<3,
        TestCustomBehavior_UserDataBit_4  = 1<<4,
        TestCustomBehavior_UserDataBit_5  = 1<<5,
        TestCustomBehavior_UserDataBit_6  = 1<<6,
        TestCustomBehavior_UserDataBit_7  = 1<<7,
        TestCustomBehavior_UserDataBit_8  = 1<<8,
        TestCustomBehavior_UserDataBit_9  = 1<<9,
        TestCustomBehavior_UserDataBit_10 = 1<<10,
        TestCustomBehavior_UserDataBit_11 = 1<<11,
        TestCustomBehavior_UserDataBit_12 = 1<<12,
        TestCustomBehavior_UserDataBit_13 = 1<<13,
        TestCustomBehavior_UserDataBit_14 = 1<<14,
        TestCustomBehavior_UserDataBit_15 = 1<<15,
    };

    /**
     * @brief コンストラクタ
     *
     */
    TestCustomBehaviorParam();

    /**
     * @brief デストラクタ
     *
     */
    ~TestCustomBehaviorParam();

    /**
     * @brief 初期値に戻す
     *
     */
    void Reset();

    /**
     * @brief テストカスタム動作パラメータを作成
     *
     * @param[in] emitterSetHandle     エミッタセットハンドル
     * @param[in] maxFrames            最大フレーム
     */
    void PreparCustomParam( nn::vfx::Handle* emitterSetHandle, float maxFrames );

   /**
     * @brief カメラの更新
     *
     */
    void Update( int frame );

   /**
     * @brief カメラ動作パラメータを設定
     *
     * @param[in] pView    　　　　モデルビュー
     * @param[in] cameraPosition   カメラ位置
     * @param[in] camUp            視線上方向ベクトル
     * @param[in] target           ターゲット位置
     */
    void SetCamera( nn::util::Matrix4x3fType*   pView,
                    nn::util::Vector3fType&     cameraPosition,
                    nn::util::Vector3fType&     target,
                    nn::util::Vector3fType&     camUp );

   /**
     * @brief プロジェクションパラメータを設定
     *
     * @param[in] pProjctionMatrix    プロジェクションマトリックス
     * @param[in] fovy                画角
     * @param[in] aspect              アスペクト
     * @param[in] zNear               スクリーンNear値
     * @param[in] zFar                スクリーンFar値
     */
    void SetProjection( nn::util::Matrix4x4fType* pProjctionMatrix,
                        float                     fovy,
                        float                     aspect,
                        float                     zNear,
                        float                     zFar );

   /**
     * @brief カメラポジションを取得
     *
     * @return    現在のカメラポジションをを返します。
     */
    nn::util::Vector3fType* GetCurrentCameraPos() { return &m_CameraPosition; }

private:
    bool                                m_IsCameraZPosUpdate;
    float                               m_CameraZPosCurrent;
    float                               m_CameraZPosPerFrame;
    float                               m_CameraYPosPerFrame;

    nn::util::Vector3fType              m_CameraPosition;            // カメラ位置
    nn::util::Matrix4x3fType*           m_View;                      // モデルビュー
    nn::util::Vector3fType              m_CamUp;
    nn::util::Vector3fType              m_Target;

    bool                                m_IsProjectionUpdate;
    float                               m_ProjectionPosPerFrame;
    float                               m_CurrentH;
    nn::util::Matrix4x4fType*           m_ProjctionMatrix;          // プロジェクション
    float                               m_Fovy;
    float                               m_Aaspect;
    float                               m_ZNear;
    float                               m_ZFar;
};


}
}
