﻿#===========================================================================
# GUI版 サンプルのビルド／実行 ツール
#
# ※このツールの起動には powershell Version 3.0 以上が必要です。
#===========================================================================
Add-Type -AssemblyName presentationframework

[xml]$loadXaml = @"
<Window xmlns="http://schemas.microsoft.com/winfx/2006/xaml/presentation"
        xmlns:x="http://schemas.microsoft.com/winfx/2006/xaml"
        Title="Eft テスト" Height="600" Width="625">

    <Window.Resources>
        <!-- 通常時のボタンの背景色 -->
        <SolidColorBrush x:Key="NormalBackgroundBrush64" Color="#D0DDDD"/>
        <!-- 通常時のボタンの背景色 -->
        <SolidColorBrush x:Key="NormalBackgroundBrushRef" Color="#DDDDD0"/>
        <!-- カスタムボタンのスタイル（64） -->
        <Style x:Key="ButtonStyle32" TargetType="{x:Type Button}">
            <Setter Property="Background" Value="{StaticResource NormalBackgroundBrush64}"/>
        </Style>
        <!-- カスタムボタンのスタイル（正解画像） -->
        <Style x:Key="ButtonStyleRef" TargetType="{x:Type Button}">
            <Setter Property="Background" Value="{StaticResource NormalBackgroundBrushRef}"/>
        </Style>
    </Window.Resources>

        <StackPanel Orientation="Vertical" Margin="2">
            <GroupBox Header="全体管理" Margin="2">
                <StackPanel Orientation="Vertical">
                    <StackPanel Orientation="Horizontal">
                        <Button Name="allClear" Content="クリア" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="ビルドされた出力やキャプチャ結果をクリアします。(注)git clean -fdx Programs,Tests,Tools" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                    <StackPanel Orientation="Horizontal">
                        <Button Name="allBuild" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="全てのビルドを行います。" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                </StackPanel>
            </GroupBox>

            <!-- エスケープ文字には エンティティ参照を使う  -->
            <GroupBox Header="HostBridge IP アドレス（実機 IP アドレスが &quot;169.*&quot; 以外は必須）" Margin="2">
                <StackPanel Orientation="Vertical">
                    <TextBlock Name="TargetAddressPattern" Text="TARGET_ADDRESS_PATTERN="/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <TextBox Name="ip0" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="." HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBox Name="ip1" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="." HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBox Name="ip2" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="." HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBox Name="ip3" Text="" Width="30" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                    <StackPanel Orientation="Horizontal">
                        <Button Name="setTargetAddressPattern" Content="設定" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="setEnvTargetAddressPattern" Content="環境変数に追加" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="resetEnvTargetAddressPattern" Content="環境変数から削除" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>
                </StackPanel>
            </GroupBox>

            <GroupBox Header="NX実機ツールの作成" Margin="2">
                <StackPanel Orientation="Vertical">
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="toolsBuild" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="NX(実機) を実行するには必須です。"/>
                    </StackPanel>
                </StackPanel>
            </GroupBox>

            <GroupBox Header="EmitterSetHandlingGfx" Margin="2">
                <StackPanel Orientation="Vertical">

                    <TextBlock Text="Win64"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="Win64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="Win64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="Win64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="Win64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="Win64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(Win)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="NXOnWin64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXOnWin64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXOnWin64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXOnWin64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXOnWin64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX64(実機) ※実行時に描画は行いません。"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Name="NXFP2_a64Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXFP2_a64Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXFP2_a64Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXFP2_a64Capture" Content="キャプチャを開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Name="NXFP2_a64Reference" Content="正解画像を開く" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="Win32"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="Win32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="Win32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="Win32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX32(Win)"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="NXOnWin32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="NXOnWin32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="NXOnWin32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="NX32(実機) ※実行時に描画は行いません。"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyle32}" Name="NXFP2_a32Build" Content="ビルド" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="NXFP2_a32Execute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyle32}" Name="NXFP2_a32Result" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                    </StackPanel>

                    <TextBlock Text="プラットフォーム間で正解画像を比較"/>
                    <StackPanel Orientation="Horizontal" HorizontalAlignment="Left">
                        <Button Style="{StaticResource ButtonStyleRef}" Name="RefimagesExecute" Content="実行" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <Button Style="{StaticResource ButtonStyleRef}" Name="RefimagesResult" Content="結果表示" Width="100" Height="20" Margin="2" HorizontalAlignment="Left" VerticalAlignment="Center"/>
                        <TextBlock Text="実行前に Win64 の ビルドが必要です。"/>
                    </StackPanel>

                </StackPanel>
            </GroupBox>


        </StackPanel>
</Window>
"@

# Windows7 等は標準が Version 2.0 の為、3 に満たない場合は起動しないようにする。
if($PSVersionTable.PSVersion.Major -lt 3){
   $message = "Powershellバージョン 3 以上が必要です。" + "現在のバージョンは " + $PSVersionTable.PSVersion.Major + " です。"
   Write-Output $message
   exit
}

# 多重ビルド抑止用のロックファイルが存在する場合は、起動時に削除を行う。
if (Test-Path Build/.lock)
{
	Remove-Item Build/.lock
}

$reader = New-Object System.Xml.XmlNodeReader $loadXaml
$window = [Windows.Markup.XamlReader]::Load($reader)

#===========================================================================
# 全体管理
#===========================================================================
$allClear   = $window.Findname("allClear");
$allBuild   = $window.Findname("allBuild");

$allClear.Add_Click({
   try
   {
      Start-Process -FilePath ".\Clean.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Clean.bat が見つかりません。")
   }
})
$allBuild.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build_All.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build_All.bat が見つかりません。")
   }
})

#===========================================================================
# Tools
#===========================================================================
$toolsBuild = $window.Findname("toolsBuild");

$toolsBuild.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build_Tools.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_Tools.bat が見つかりません。")
   }
})

#===========================================================================
# ScreenCapture / win64
#===========================================================================
$Win64Build     = $window.Findname("Win64Build");
$Win64Execute   = $window.Findname("Win64Execute");
$Win64Result    = $window.Findname("Win64Result");
$Win64Capture   = $window.Findname("Win64Capture");
$Win64Reference = $window.Findname("Win64Reference");

$Win64Build.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build_Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_Win64.bat が見つかりません。")
   }
})
$Win64Execute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-platform.Win64.bat が見つかりません。")
   }
})
$Win64Result.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result_Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_Win64.bat が見つかりません。")
   }
})
$Win64Capture.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_EmitterSetHandlingGfx\x64-v140\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_EmitterSetHandlingGfx\x64-v140\captured が見つかりません。")
   }
})
$Win64Reference.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\EmitterSetHandling\Vfx\Win64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\EmitterSetHandling\Vfx\Win64 が見つかりません。")
   }
})

#===========================================================================
# win32
#===========================================================================
$Win32Build     = $window.Findname("Win32Build");
$Win32Execute   = $window.Findname("Win32Execute");
$Win32Result    = $window.Findname("Win32Result");

$Win32Build.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build_Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_Win32.bat が見つかりません。")
   }
})
$Win32Execute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-platform.Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-platform.Win32.bat が見つかりません。")
   }
})
$Win32Result.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result_Win32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_Win32.bat が見つかりません。")
   }
})

#===========================================================================
# NXOnWin64
#===========================================================================
$NXOnWin64Build     = $window.Findname("NXOnWin64Build");
$NXOnWin64Execute   = $window.Findname("NXOnWin64Execute");
$NXOnWin64Result    = $window.Findname("NXOnWin64Result");
$NXOnWin64Capture   = $window.Findname("NXOnWin64Capture");
$NXOnWin64Reference = $window.Findname("NXOnWin64Reference");

$NXOnWin64Build.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build_NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_NXOnWin64.bat が見つかりません。")
   }
})
$NXOnWin64Execute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-platform.NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-platform.NXOnWin64.bat が見つかりません。")
   }
})
$NXOnWin64Result.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result_NXOnWin64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_NXOnWin64.bat が見つかりません。")
   }
})
$NXOnWin64Capture.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_EmitterSetHandlingGfx\NX-x64-v140\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_EmitterSetHandlingGfx\NX-x64-v140\captured が見つかりません。")
   }
})
$NXOnWin64Reference.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\EmitterSetHandling\Vfx\NXOnWin64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\EmitterSetHandling\Vfx\NXOnWin64 が見つかりません。")
   }
})

#===========================================================================
# NXOnWin32
#===========================================================================
$NXOnWin32Build     = $window.Findname("NXOnWin32Build");
$NXOnWin32Execute   = $window.Findname("NXOnWin32Execute");
$NXOnWin32Result    = $window.Findname("NXOnWin32Result");

$NXOnWin32Build.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build_NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_NXOnWin32.bat が見つかりません。")
   }
})
$NXOnWin32Execute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-platform.NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-platform.NXOnWin32.bat が見つかりません。")
   }
})
$NXOnWin32Result.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result_NXOnWin32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_NXOnWin32.bat が見つかりません。")
   }
})

#===========================================================================
# NXFP2-a64
#===========================================================================
$NXFP2_a64Build     = $window.Findname("NXFP2_a64Build");
$NXFP2_a64Execute   = $window.Findname("NXFP2_a64Execute");
$NXFP2_a64Result    = $window.Findname("NXFP2_a64Result");
$NXFP2_a64Capture   = $window.Findname("NXFP2_a64Capture");
$NXFP2_a64Reference = $window.Findname("NXFP2_a64Reference");

$NXFP2_a64Build.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build_NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_NXFP2-a64.bat が見つかりません。")
   }
})
$NXFP2_a64Execute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-platform.NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-platform.NXFP2-a64.bat が見つかりません。")
   }
})
$NXFP2_a64Result.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result_NXFP2-a64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_NXFP2-a64.bat が見つかりません。")
   }
})
$NXFP2_a64Capture.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_EmitterSetHandlingGfx\NX-NXFP2-a64\captured"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\Outputs\Graphics\Artifacts\testEft_EmitterSetHandlingGfx\NX-NXFP2-a64\captured が見つかりません。")
   }
})
$NXFP2_a64Reference.Add_Click({
   try
   {
      Start-Process -FilePath "..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\EmitterSetHandling\Vfx\NX-NXFP2-a64"
   }
   catch
   {
      $Host.UI.WriteLine("..\..\..\..\..\..\..\..\Externals\TestBinaries\Eft\ReferenceImages\EmitterSetHandling\Vfx\NX-NXFP2-a64 が見つかりません。")
   }
})

#===========================================================================
# NXFP2-a32
#===========================================================================
$NXFP2_a32Build     = $window.Findname("NXFP2_a32Build");
$NXFP2_a32Execute   = $window.Findname("NXFP2_a32Execute");
$NXFP2_a32Result    = $window.Findname("NXFP2_a32Result");

$NXFP2_a32Build.Add_Click({
   try
   {
      Start-Process -FilePath ".\Build\Build_NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Build\Build_NXFP2-a32.bat が見つかりません。")
   }
})
$NXFP2_a32Execute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-platform.NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-platform.NXFP2-a32.bat が見つかりません。")
   }
})
$NXFP2_a32Result.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result_NXFP2-a32.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result_NXFP2-a32.bat が見つかりません。")
   }
})

#===========================================================================
# ScreenCapture / 正解画像
#===========================================================================
$RefimagesExecute   = $window.Findname("RefimagesExecute");
$RefimagesResult    = $window.Findname("RefimagesResult");

$RefimagesExecute.Add_Click({
   try
   {
      Start-Process -FilePath ".\Execute\RunTest-CompareReferenceImages-platform.Win64.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Execute\RunTest-CompareReferenceImages-platform.Win64.bat が見つかりません。")
   }
})
$RefimagesResult.Add_Click({
   try
   {
      Start-Process -FilePath ".\Result\Result-CompareReferenceImages.bat"
   }
   catch
   {
      $Host.UI.WriteLine("Result\Result-CompareReferenceImages.bat が見つかりません。")
   }
})

#===========================================================================
# TARGET_ADDRESS_PATTERN
#===========================================================================
$ip0        = $window.Findname("ip0");
$ip1        = $window.Findname("ip1");
$ip2        = $window.Findname("ip2");
$ip3        = $window.Findname("ip3");
$ta         = $window.Findname("TargetAddressPattern");
$setTa      = $window.Findname("setTargetAddressPattern");
$setEnvTa   = $window.Findname("setEnvTargetAddressPattern");
$resetEnvTa = $window.Findname("resetEnvTargetAddressPattern");

if (($env:TARGET_ADDRESS_PATTERN).Length -eq 0)
{
#   "undefined TARGET_ADDRESS_PATTERN"
}
else
{
   $targetAddressPattern = ($env:TARGET_ADDRESS_PATTERN);

   $ta.Text = "TARGET_ADDRESS_PATTERN=" + $targetAddressPattern;

   $ip = $targetAddressPattern.Split(".");
   $ip0.Text = $ip[0]
   $ip1.Text = $ip[1]
   $ip2.Text = $ip[2]
   $ip3.Text = $ip[3]
}

$setTa.Add_Click({
   $ip = $ip0.Text + "." + $ip1.Text + "." + $ip2.Text + "." + $ip3.Text;
   $ta.Text = "TARGET_ADDRESS_PATTERN=" + $ip;

   set-item env:TARGET_ADDRESS_PATTERN -value $ip
})
$setEnvTa.Add_Click({
   $ip = $ip0.Text + "." + $ip1.Text + "." + $ip2.Text + "." + $ip3.Text;
   $ta.Text = "TARGET_ADDRESS_PATTERN=" + $ip;

   set-item env:TARGET_ADDRESS_PATTERN -value $ip

   # 永続的に環境変数を設定する
   [Environment]::SetEnvironmentVariable("TARGET_ADDRESS_PATTERN", $ip, [EnvironmentVariableTarget]::User)
})
$resetEnvTa.Add_Click({
   $ta.Text = "TARGET_ADDRESS_PATTERN="

   set-item env:TARGET_ADDRESS_PATTERN -value ""

   # 永続的に環境変数を設定する
   [Environment]::SetEnvironmentVariable("TARGET_ADDRESS_PATTERN", $null, [EnvironmentVariableTarget]::User)
})

$result = $window.ShowDialog()
