﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt/gfx/testGfx_ResultHtml.h>
#include "testGraphics_Path.h"
#include "testGraphics_Allocator.hpp"

namespace nnt{ namespace graphics{

    class ImageCompareResult
    {
    public:
        ImageCompareResult();
        ~ImageCompareResult();
        void Initialize(
            const char* resultDirPath,
            const Allocator* allocator);
        void Finalize();
        bool HasNgFrame() const;

        void AddDataHeader(const char* title, nnt::gfx::NntGfxResultHtml::Table& table);
        void AddCompareResult(
            bool success,
            int difference,
            const char* name,
            const char* capImgPath,
            const char* refImgPath,
            const char* defImgPath);
        void SaveResultHtml();
        void SaveNgResultHtml(bool success);

        const char* GetCapturedImageDirectoryPath() const NN_NOEXCEPT;
        const char* GetReferenceImageDirectoryPath() const NN_NOEXCEPT;
        const char* GetDifferenceImageDirectoryPath() const NN_NOEXCEPT;

        nnt::gfx::NntGfxResultHtml::Table& GetResultHtmlTable() { return m_ResultHtmlTable; }
        nnt::gfx::NntGfxResultHtml::Table& GetNgResultHtmlTable() { return m_NgResultHtmlTable; }

    private:
        void SetupSummaryTable(nnt::gfx::NntGfxResultHtml::Table* pOutValue);

    private:
        const Allocator* m_Allocator;
        nnt::graphics::Path m_ResultDirPath;
        nnt::graphics::Path m_CapturedImageDirectoryPath;
        nnt::graphics::Path m_ReferenceImageDirectoryPath;
        nnt::graphics::Path m_DifferenceImageDirectoryPath;
        nnt::gfx::NntGfxResultHtml::Table m_ResultHtmlTable;
        nnt::gfx::NntGfxResultHtml::Table m_NgResultHtmlTable;
        int m_NumberOfTotalFrames;
        int m_NumberOfOkFrames;
        int m_NumberOfNgFrames;
    };

}}
