﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>
#include <cstdlib>

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/fsUtil/testFs_util.h>

#include <nn/nn_Log.h>
#include <nn/init.h>
#include <nn/os.h>

#include <nn/gc/gc.h>
#include <nn/dd.h>
#include <nn/gc/detail/gc_GcCrypto.h>

#include <nn/gc/detail/gc_Define.h>
#include <nn/gc/detail/gc_Util.h>


#define NN_TESTGC_EXPECT_SUCCESS(result) \
    NNT_EXPECT_RESULT_SUCCESS(result)

#define NN_TESTGC_EXPECT_INCLUDES(expect, result) \
    NNT_EXPECT_RESULT_FAILURE(expect, result)

// 定数
const size_t WorkBufferSize = 2 * 1024 * 1024;
const size_t MemoryHeapSize = 64 * 1024 * 1024;
const size_t DataBufferSize = MemoryHeapSize / 2;
const size_t MemoryHeapSizeForMalloc = MemoryHeapSize / 4;


void TESTOUT(bool flag, const char* str) NN_NOEXCEPT;
void TESTCMP(char* a, char* b, size_t length, std::string str) NN_NOEXCEPT;
void TESTCMP_NE(char* a, char* b, size_t length, std::string str) NN_NOEXCEPT;
void PrintArray(const char* buffer, const size_t bufferLength) NN_NOEXCEPT;
