﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#if ! defined(NN_BUILD_CONFIG_OS_WIN)
#include <nn/fs/fs_GameCardForInspection.h>
#include <nn/spl/spl_Api.h>
#include <nn/sdmmc/sdmmc_Common.h>
#endif

#include "GcCommon.h"
#include "testGc_Unit_GcLibrary_Util.h"

char*     g_WorkBuffer;
uintptr_t g_WorkBufferAddress;
char*     g_DataBuffer;
uintptr_t g_DataBufferAddress;
uintptr_t g_MallocBufferAddress;
nn::os::EventType g_CardDetectionEvent;

nn::dd::DeviceAddressSpaceType g_Das;
nn::dd::DeviceVirtualAddress g_WorkBufferDeviceVirtualAddress;
nn::dd::DeviceVirtualAddress g_DataBufferDeviceVirtualAddress;


char g_CalKey[] = {
    0xd4, 0xd0, 0x7f, 0xb6, 0xe0, 0xb8, 0x63, 0x82, 0x26, 0xfd, 0x76, 0x88, 0x7a, 0x86, 0x8f, 0x03
};



extern "C" void nninitStartup()
{
    nn::Result result = nn::os::SetMemoryHeapSize(MemoryHeapSize);
    NN_ABORT_UNLESS(result.IsSuccess(), "Cannot set MemoryHeapSize.");

    // メモリヒープから WorkBuffer で使用するメモリ領域を確保
    result = nn::os::AllocateMemoryBlock(&g_WorkBufferAddress, WorkBufferSize);
    NN_ABORT_UNLESS(result.IsSuccess(), "Cannot AllocateMemoryBlock0.");

    // メモリヒープから DataBuffer で使用するメモリ領域を確保
    result = nn::os::AllocateMemoryBlock(&g_DataBufferAddress, DataBufferSize);
    NN_ABORT_UNLESS(result.IsSuccess(), "Cannot AllocateMemoryBlock1.");

    // メモリヒープから malloc で使用するメモリ領域を確保
    result = nn::os::AllocateMemoryBlock(&g_MallocBufferAddress, MemoryHeapSizeForMalloc);
    NN_ABORT_UNLESS(result.IsSuccess(), "Cannot AllocateMemoryBlock2.");

    // malloc 用のメモリ領域を設定する
    nn::init::InitializeAllocator(reinterpret_cast<void*>(g_MallocBufferAddress), MemoryHeapSizeForMalloc);
}

// 挿抜があった際に呼ばれるコールバック関数：GC のスレッドをブロックしてしまうため、イベントのシグナルのみにとどめる必要がある
void SignalDetectionEvents(void *pParameter)
{
    NN_UNUSED(pParameter);
    nn::os::SignalEvent(&g_CardDetectionEvent);
}

void InitializeDriver()
{
#if ! defined(NN_BUILD_CONFIG_OS_WIN)
    nn::spl::InitializeForFs();

    NN_LOG("Initialize gc driver.\n");

    nn::fs::FinalizeGameCardDriver();

    // クロック制御は pcv 経由で行う
    nn::sdmmc::SwitchToPcvClockResetControl();
#endif

    // 自信で監視するイベントを用意する
    nn::os::InitializeEvent(&g_CardDetectionEvent, false, nn::os::EventClearMode_ManualClear);

    g_WorkBuffer = reinterpret_cast<char*>(g_WorkBufferAddress);
    g_DataBuffer = reinterpret_cast<char*>(g_DataBufferAddress);

    // TODO: TEMP: [win32 test] 2016/05/12
    // SetupDeviceAddressSpace(&g_Das, nn::dd::DeviceName::DeviceName_Sdmmc2a);

    // TODO: TEMP: [win32 test] 2016/05/12
    // g_WorkBufferDeviceVirtualAddress = MapDeviceAddressSpaceAligned(&g_Das, g_WorkBufferAddress, WorkBufferSize, 0);
    g_WorkBufferDeviceVirtualAddress = 0;
    nn::gc::Initialize(g_WorkBuffer, WorkBufferSize, g_WorkBufferDeviceVirtualAddress);

    // TODO: TEMP: [win32 test] 2016/05/12
    // g_DataBufferDeviceVirtualAddress = MapDeviceAddressSpaceAligned(&g_Das, g_DataBufferAddress, DataBufferSize, g_WorkBufferDeviceVirtualAddress + WorkBufferSize);
    g_DataBufferDeviceVirtualAddress = 0;
    nn::gc::RegisterDeviceVirtualAddress(g_DataBufferAddress, DataBufferSize, g_DataBufferDeviceVirtualAddress);

    nn::gc::RegisterDetectionEventCallback(SignalDetectionEvents, nullptr);
}

void FinalizeDriver()
{
    // TODO: TEMP: [win32 test] 2016/05/12
    /*nn::gc::UnregisterDeviceVirtualAddress(g_DataBufferAddress, DataBufferSize, g_DataBufferDeviceVirtualAddress);
    UnmapDeviceAddressSpaceAligned(&g_Das, g_DataBufferAddress, DataBufferSize, g_DataBufferDeviceVirtualAddress);

    nn::gc::Finalize();
    UnmapDeviceAddressSpaceAligned(&g_Das, g_WorkBufferAddress, WorkBufferSize, g_WorkBufferDeviceVirtualAddress);*/

    // TODO: TEMP: [win32 test] 2016/05/12
    // CleanDeviceAddressSpace(&g_Das, nn::dd::DeviceName::DeviceName_Sdmmc2a);

    // nn::spl::Finalize();
}

extern "C" void nnMain()
{
    NN_LOG("Setting End.Gc Test Start.\n");

    InitializeDriver();

    NN_LOG("Test Start\n");
    int     argc = nn::os::GetHostArgc();
    char**  argv = nn::os::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);
    auto ret = RUN_ALL_TESTS();

    FinalizeDriver();

    nn::os::FreeMemoryBlock(g_MallocBufferAddress, MemoryHeapSizeForMalloc);
    nn::os::FreeMemoryBlock(g_DataBufferAddress, DataBufferSize);
    nn::os::FreeMemoryBlock(g_WorkBufferAddress, WorkBufferSize);
    NN_LOG("Test End\n");

    nnt::Exit(ret);
}

