﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/fsUtil/testFs_util.h>

#include "testGc_Integration_CardInsertionAndRemoval.h"


// *** Ruby script generated code ------------------------------------------------ ***

#define NN_DETAIL_GC_TEST_FRAMEWORK_TEST_ENABLE
#define NN_DETAIL_GC_TEST_FRAMEWORK_FAIL_TEST_ENABLE
#define NN_DETAIL_GC_TEST_SESSION_ESTABLISHMENT_ENABLE
#define NN_DETAIL_GC_TEST_INSERTION_ENABLE
#define NN_DETAIL_GC_TEST_REMOVAL_ENABLE
#define NN_DETAIL_GC_TEST_STATE_TRANSITION_ENABLE
#define NN_DETAIL_GC_TEST_PROHIBITED_ENABLE
#define NN_DETAIL_GC_TEST_SLEEP_ENABLE
#define NN_DETAIL_GC_TEST_INTEGRATION_ENABLE
#define NN_DETAIL_GC_TEST_READ_ENABLE


// テストフレームワークのテスト
#ifdef NN_DETAIL_GC_TEST_FRAMEWORK_TEST_ENABLE
TEST_F(GcTest, TestFrameworkTestEstablishingNotInsertedNone)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, GcAction_None, AsicSessionState_Establishing, GameCardState_NotInserted, false);
}
TEST_F(GcTest, TestFrameworkTestEstablishingInsertedNone)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, GcAction_None, AsicSessionState_Establishing, GameCardState_Inserted, false);
}
TEST_F(GcTest, TestFrameworkTestReEstablishingNotInsertedNone)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, GcAction_None, AsicSessionState_ReEstablishing, GameCardState_NotInserted, false);
}
TEST_F(GcTest, TestFrameworkTestReEstablishingInsertedNone)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, GcAction_None, AsicSessionState_ReEstablishing, GameCardState_Inserted, false);
}
TEST_F(GcTest, TestFrameworkTestEstablishedNotInsertedNone)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_NotInserted, GcAction_None, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, TestFrameworkTestEstablishedInsertedNone)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Inserted, GcAction_None, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, TestFrameworkTestEstablishedNormalNone)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, GcAction_None, AsicSessionState_Established, GameCardState_Normal, false);
}
TEST_F(GcTest, TestFrameworkTestEstablishedSecureNone)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, GcAction_None, AsicSessionState_Established, GameCardState_Secure, false);
}
#endif

// テストフレームワークのテスト（異常系）
#ifdef NN_DETAIL_GC_TEST_FRAMEWORK_FAIL_TEST_ENABLE
TEST_F(GcTest, TestFrameworkFailTestInitialNormalNone)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Normal, GcAction_None, AsicSessionState_Initial, GameCardState_Normal, true);
}
TEST_F(GcTest, TestFrameworkFailTestInitialSecureNone)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Secure, GcAction_None, AsicSessionState_Initial, GameCardState_Secure, true);
}
TEST_F(GcTest, TestFrameworkFailTestInitialDebugNone)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Debug, GcAction_None, AsicSessionState_Initial, GameCardState_Debug, true);
}
TEST_F(GcTest, TestFrameworkFailTestEstablishingNormalNone)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Normal, GcAction_None, AsicSessionState_Establishing, GameCardState_Normal, true);
}
TEST_F(GcTest, TestFrameworkFailTestEstablishingSecureNone)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Secure, GcAction_None, AsicSessionState_Establishing, GameCardState_Secure, true);
}
TEST_F(GcTest, TestFrameworkFailTestEstablishingDebugNone)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Debug, GcAction_None, AsicSessionState_Establishing, GameCardState_Debug, true);
}
TEST_F(GcTest, TestFrameworkFailTestReEstablishingNormalNone)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Normal, GcAction_None, AsicSessionState_ReEstablishing, GameCardState_Normal, true);
}
TEST_F(GcTest, TestFrameworkFailTestReEstablishingSecureNone)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Secure, GcAction_None, AsicSessionState_ReEstablishing, GameCardState_Secure, true);
}
TEST_F(GcTest, TestFrameworkFailTestReEstablishingDebugNone)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Debug, GcAction_None, AsicSessionState_ReEstablishing, GameCardState_Debug, true);
}
#endif

// セッション構築
#ifdef NN_DETAIL_GC_TEST_SESSION_ESTABLISHMENT_ENABLE
TEST_F(GcTest, StateSessionEstablishmentInitialNotInsertedWait)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, GcAction_Wait, AsicSessionState_Establishing, GameCardState_NotInserted, false);
}
TEST_F(GcTest, StateSessionEstablishmentEstablishingNotInsertedWait)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, GcAction_Wait, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, StateSessionEstablishmentReEstablishingNotInsertedWait)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, GcAction_Wait, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, StateSessionEstablishmentInitialInsertedWait)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Inserted, GcAction_Wait, AsicSessionState_Establishing, GameCardState_Inserted, false);
}
TEST_F(GcTest, StateSessionEstablishmentEstablishingInsertedWait)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, GcAction_Wait, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, StateSessionEstablishmentReEstablishingInsertedWait)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, GcAction_Wait, AsicSessionState_Established, GameCardState_Inserted, false);
}
#endif

// 挿入バリエーション
#ifdef NN_DETAIL_GC_TEST_INSERTION_ENABLE
TEST_F(GcTest, StateInsertInitialNotInsertedInsertCardWait)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, GcAction_InsertCardWait, AsicSessionState_Establishing, GameCardState_Inserted, false);
}
TEST_F(GcTest, StateInsertEstablishingNotInsertedInsertCardWait)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, GcAction_InsertCardWait, AsicSessionState_Establishing, GameCardState_Inserted, false);
}
TEST_F(GcTest, StateInsertReEstablishingNotInsertedInsertCardWait)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, GcAction_InsertCardWait, AsicSessionState_ReEstablishing, GameCardState_Inserted, false);
}
TEST_F(GcTest, StateInsertEstablishedNotInsertedInsertCardWait)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_NotInserted, GcAction_InsertCardWait, AsicSessionState_Established, GameCardState_Inserted, false);
}
#endif

// 抜去バリエーション
#ifdef NN_DETAIL_GC_TEST_REMOVAL_ENABLE
TEST_F(GcTest, StateRemoveInitialInsertedRemoveCardWait)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Inserted, GcAction_RemoveCardWait, AsicSessionState_Establishing, GameCardState_NotInserted, false);
}
TEST_F(GcTest, StateRemoveEstablishingInsertedRemoveCardWait)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, GcAction_RemoveCardWait, AsicSessionState_Establishing, GameCardState_NotInserted, false);
}
TEST_F(GcTest, StateRemoveReEstablishingInsertedRemoveCardWait)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, GcAction_RemoveCardWait, AsicSessionState_ReEstablishing, GameCardState_NotInserted, false);
}
TEST_F(GcTest, StateRemoveEstablishedInsertedRemoveCardWait)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Inserted, GcAction_RemoveCardWait, AsicSessionState_Establishing, GameCardState_NotInserted, false);
}
TEST_F(GcTest, StateRemoveEstablishedNormalRemoveCardWait)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, GcAction_RemoveCardWait, AsicSessionState_Establishing, GameCardState_NotInserted, false);
}
TEST_F(GcTest, StateRemoveEstablishedSecureRemoveCardWait)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, GcAction_RemoveCardWait, AsicSessionState_Establishing, GameCardState_NotInserted, false);
}
#endif

// 遷移シーケンス
#ifdef NN_DETAIL_GC_TEST_STATE_TRANSITION_ENABLE
TEST_F(GcTest, StateTransitionInitialInsertedActivate)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Inserted, GcAction_Activate, AsicSessionState_Established, GameCardState_Normal, false);
}
TEST_F(GcTest, StateTransitionEstablishingInsertedActivate)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, GcAction_Activate, AsicSessionState_Established, GameCardState_Normal, false);
}
TEST_F(GcTest, StateTransitionEstablishedInsertedActivate)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Inserted, GcAction_Activate, AsicSessionState_Established, GameCardState_Normal, false);
}
TEST_F(GcTest, StateTransitionReEstablishingInsertedActivate)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, GcAction_Activate, AsicSessionState_Established, GameCardState_Normal, false);
}
TEST_F(GcTest, StateTransitionEstablishedNormalChangeSecure)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, GcAction_ChangeSecure, AsicSessionState_Established, GameCardState_Secure, false);
}
TEST_F(GcTest, StateTransitionEstablishedNormalActivate)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, GcAction_Activate, AsicSessionState_Established, GameCardState_Normal, false);
}
TEST_F(GcTest, StateTransitionEstablishedSecureActivate)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, GcAction_Activate, AsicSessionState_Established, GameCardState_Secure, false);
}
#endif

// 禁止シーケンス
#ifdef NN_DETAIL_GC_TEST_PROHIBITED_ENABLE
TEST_F(GcTest, ProhibitedInitialNotInsertedActivate)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, GcAction_Activate, AsicSessionState_Initial, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ProhibitedEstablishingNotInsertedActivate)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, GcAction_Activate, AsicSessionState_Establishing, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ProhibitedEstablishedNotInsertedActivate)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_NotInserted, GcAction_Activate, AsicSessionState_Established, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ProhibitedReEstablishingNotInsertedActivate)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, GcAction_Activate, AsicSessionState_ReEstablishing, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ProhibitedInitialNotInsertedChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, GcAction_ChangeSecure, AsicSessionState_Initial, GameCardState_NotInserted, true), "");
}
TEST_F(GcTest, ProhibitedInitialInsertedChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Inserted, GcAction_ChangeSecure, AsicSessionState_Initial, GameCardState_Inserted, true), "");
}
TEST_F(GcTest, ProhibitedInitialSecureChangeSecure)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Secure, GcAction_ChangeSecure, AsicSessionState_Initial, GameCardState_Secure, true);
}
TEST_F(GcTest, ProhibitedEstablishingNotInsertedChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, GcAction_ChangeSecure, AsicSessionState_Establishing, GameCardState_NotInserted, true), "");
}
TEST_F(GcTest, ProhibitedEstablishingInsertedChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, GcAction_ChangeSecure, AsicSessionState_Establishing, GameCardState_Inserted, true), "");
}
TEST_F(GcTest, ProhibitedEstablishingSecureChangeSecure)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Secure, GcAction_ChangeSecure, AsicSessionState_Establishing, GameCardState_Secure, true);
}
TEST_F(GcTest, ProhibitedEstablishedNotInsertedChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_Established, GameCardState_NotInserted, GcAction_ChangeSecure, AsicSessionState_Established, GameCardState_NotInserted, true), "");
}
TEST_F(GcTest, ProhibitedEstablishedInsertedChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Inserted, GcAction_ChangeSecure, AsicSessionState_Established, GameCardState_Inserted, true), "");
}
TEST_F(GcTest, ProhibitedEstablishedSecureChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, GcAction_ChangeSecure, AsicSessionState_Established, GameCardState_Secure, true), "");
}
TEST_F(GcTest, ProhibitedReEstablishingNotInsertedChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, GcAction_ChangeSecure, AsicSessionState_ReEstablishing, GameCardState_NotInserted, true), "");
}
TEST_F(GcTest, ProhibitedReEstablishingInsertedChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, GcAction_ChangeSecure, AsicSessionState_ReEstablishing, GameCardState_Inserted, true), "");
}
TEST_F(GcTest, ProhibitedReEstablishingSecureChangeSecureDeathTest)
{
    EXPECT_DEATH_IF_SUPPORTED(CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Secure, GcAction_ChangeSecure, AsicSessionState_ReEstablishing, GameCardState_Secure, true), "");
}
#endif

// スリープシーケンス
#ifdef NN_DETAIL_GC_TEST_SLEEP_ENABLE
TEST_F(GcTest, SleepNotInsertedInitialNotInsertedPutToSleep)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, GcAction_PutToSleep, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedEstablishingNotInsertedPutToSleep)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, GcAction_PutToSleep, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedReEstablishingNotInsertedPutToSleep)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, GcAction_PutToSleep, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedInitialNotInsertedPutToSleep2)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedEstablishingNotInsertedPutToSleep2)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedReEstablishingNotInsertedPutToSleep2)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedInitialNotInsertedPutToSleep3)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_InsertCard, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedEstablishingNotInsertedPutToSleep3)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_InsertCard, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedReEstablishingNotInsertedPutToSleep3)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_InsertCard, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedInitialNotInsertedPutToSleep4)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_InsertCard, GcAction_RemoveCard, GcAction_Wait3, GcAction_Awaken, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedEstablishingNotInsertedPutToSleep4)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_InsertCard, GcAction_RemoveCard, GcAction_Wait3, GcAction_Awaken, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepNotInsertedReEstablishingNotInsertedPutToSleep4)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_InsertCard, GcAction_RemoveCard, GcAction_Wait3, GcAction_Awaken, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, false);
}
TEST_F(GcTest, SleepInsertedInitialInsertedPutToSleep)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Inserted, GcAction_PutToSleep, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedEstablishingInsertedPutToSleep)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, GcAction_PutToSleep, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedReEstablishingInsertedPutToSleep)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, GcAction_PutToSleep, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedInitialInsertedPutToSleep2)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Inserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedEstablishingInsertedPutToSleep2)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedReEstablishingInsertedPutToSleep2)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedInitialInsertedPutToSleep3)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_RemoveCard, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Inserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedEstablishingInsertedPutToSleep3)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_RemoveCard, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedReEstablishingInsertedPutToSleep3)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_RemoveCard, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedInitialInsertedPutToSleep4)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_RemoveCard, GcAction_InsertCard, GcAction_Wait3, GcAction_Awaken, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Inserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedEstablishingInsertedPutToSleep4)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_RemoveCard, GcAction_InsertCard, GcAction_Wait3, GcAction_Awaken, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedReEstablishingInsertedPutToSleep4)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_RemoveCard, GcAction_InsertCard, GcAction_Wait3, GcAction_Awaken, GcAction_Wait3};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, false);
}
TEST_F(GcTest, SleepInsertedEstablishedSecurePutToSleep)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Read};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, actionList, actionListLength, AsicSessionState_Established, GameCardState_Secure, true);
}
#endif

// リード
#ifdef NN_DETAIL_GC_TEST_READ_ENABLE
TEST_F(GcTest, ReadEstablishedNormalReadNormal)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, GcAction_ReadNormal, AsicSessionState_Established, GameCardState_Normal, false);
}
TEST_F(GcTest, ReadEstablishedSecureReadNormal)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, GcAction_ReadNormal, AsicSessionState_Established, GameCardState_Secure, true);
}
TEST_F(GcTest, ReadEstablishedNormalPutToSleep)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken, GcAction_ReadNormal};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, actionList, actionListLength, AsicSessionState_Established, GameCardState_Normal, false);
}
TEST_F(GcTest, ReadEstablishedSecurePutToSleep)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken, GcAction_ReadNormal};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, actionList, actionListLength, AsicSessionState_Established, GameCardState_Secure, true);
}
TEST_F(GcTest, ReadEstablishedNormalReadSecure)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, GcAction_ReadSecure, AsicSessionState_Established, GameCardState_Normal, true);
}
TEST_F(GcTest, ReadEstablishedSecureReadSecure)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, GcAction_ReadSecure, AsicSessionState_Established, GameCardState_Secure, false);
}
TEST_F(GcTest, ReadEstablishedNormalPutToSleep2)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken, GcAction_ReadSecure};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, actionList, actionListLength, AsicSessionState_Established, GameCardState_Normal, true);
}
TEST_F(GcTest, ReadEstablishedSecurePutToSleep2)
{
    GcAction actionList[] = {GcAction_PutToSleep, GcAction_Awaken, GcAction_ReadSecure};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, actionList, actionListLength, AsicSessionState_Established, GameCardState_Secure, false);
}
TEST_F(GcTest, ReadInitialNotInsertedRead)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, GcAction_Read, AsicSessionState_Initial, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ReadInitialInsertedRead)
{
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_Inserted, GcAction_Read, AsicSessionState_Initial, GameCardState_Inserted, true);
}
TEST_F(GcTest, ReadEstablishingNotInsertedRead)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_NotInserted, GcAction_Read, AsicSessionState_Establishing, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ReadEstablishingInsertedRead)
{
    CheckStateAndActionResult(AsicSessionState_Establishing, GameCardState_Inserted, GcAction_Read, AsicSessionState_Establishing, GameCardState_Inserted, true);
}
TEST_F(GcTest, ReadEstablishedNotInsertedRead)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_NotInserted, GcAction_Read, AsicSessionState_Established, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ReadEstablishedInsertedRead)
{
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Inserted, GcAction_Read, AsicSessionState_Established, GameCardState_Inserted, true);
}
TEST_F(GcTest, ReadReEstablishingNotInsertedRead)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_NotInserted, GcAction_Read, AsicSessionState_ReEstablishing, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ReadReEstablishingInsertedRead)
{
    CheckStateAndActionResult(AsicSessionState_ReEstablishing, GameCardState_Inserted, GcAction_Read, AsicSessionState_ReEstablishing, GameCardState_Inserted, true);
}
TEST_F(GcTest, ReadEstablishedNormalRemoveCardWait)
{
    GcAction actionList[] = {GcAction_RemoveCardWait, GcAction_Read};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ReadEstablishedSecureRemoveCardWait)
{
    GcAction actionList[] = {GcAction_RemoveCardWait, GcAction_Read};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, actionList, actionListLength, AsicSessionState_Established, GameCardState_NotInserted, true);
}
TEST_F(GcTest, ReadEstablishedNormalRemoveCardWait2)
{
    GcAction actionList[] = {GcAction_RemoveCardWait, GcAction_InsertCardWait, GcAction_Read};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Normal, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, true);
}
TEST_F(GcTest, ReadEstablishedSecureRemoveCardWait2)
{
    GcAction actionList[] = {GcAction_RemoveCardWait, GcAction_InsertCardWait, GcAction_Read};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Established, GameCardState_Secure, actionList, actionListLength, AsicSessionState_Established, GameCardState_Inserted, true);
}
#endif

// 複合シーケンス
#ifdef NN_DETAIL_GC_TEST_INTEGRATION_ENABLE
TEST_F(GcTest, IntegrationInitialNotInsertedInsertCardWait)
{
    GcAction actionList[] = {GcAction_InsertCardWait, GcAction_Activate, GcAction_Read, GcAction_PutToSleep, GcAction_Awaken, GcAction_ChangeSecure, GcAction_ReadSecure, GcAction_PutToSleep, GcAction_RemoveCard, GcAction_InsertCard, GcAction_Awaken, GcAction_Wait, GcAction_Activate, GcAction_Read, GcAction_PutToSleep, GcAction_Awaken, GcAction_Deactivate, GcAction_Activate, GcAction_Deactivate, GcAction_PutToSleep, GcAction_Awaken, GcAction_Activate, GcAction_Read, GcAction_ChangeSecure, GcAction_ReadSecure};
    int actionListLength = sizeof(actionList) / sizeof(GcAction);
    CheckStateAndActionResult(AsicSessionState_Initial, GameCardState_NotInserted, actionList, actionListLength, AsicSessionState_Established, GameCardState_Secure, false);
}
#endif

