# -*- coding: utf-8 -*-
# /*--------------------------------------------------------------------------------*
#   Copyright (C)Nintendo All rights reserved.
#
#   These coded instructions, statements, and computer programs contain proprietary
#   information of Nintendo and/or its licensed developers and are protected by
#   national and international copyright laws. They may not be disclosed to third
#   parties or copied or duplicated in any form, in whole or in part, without the
#   prior written consent of Nintendo.
#
#   The content herein is highly confidential and should be handled accordingly.
#  *--------------------------------------------------------------------------------*/

ExpectedDeathList = %w(
ProhibitedInitialNotInsertedChangeSecure
ProhibitedInitialInsertedChangeSecure
ProhibitedEstablishingNotInsertedChangeSecure
ProhibitedEstablishingInsertedChangeSecure
ProhibitedEstablishedNotInsertedChangeSecure
ProhibitedEstablishedInsertedChangeSecure
ProhibitedEstablishedSecureChangeSecure
ProhibitedReEstablishingNotInsertedChangeSecure
ProhibitedReEstablishingInsertedChangeSecure
ProhibitedReEstablishingSecureChangeSecure)

AsicSessionState = %i(Initial Establishing Established ReEstablishing)
GameCardState = %i(NotInserted Inserted Normal Secure Debug)
GcAction = %i(None Wait Wait2 Wait3 InsertCard RemoveCard InsertCardWait RemoveCardWait Activate ChangeSecure PutToSleep Awaken Read ReadNormal ReadSecure)

OUTPUT_FILE_PATH = "testGc_Integration_CardInsertionAndRemovalImpl.cpp"
FAIL_TSET = true
UTF8_BOM = [0xEF, 0xBB, 0xBF].pack('C*')
TEST_LIST = %i(FRAMEWORK_TEST FRAMEWORK_FAIL_TEST SESSION_ESTABLISHMENT INSERTION REMOVAL STATE_TRANSITION PROHIBITED SLEEP INTEGRATION READ)
# DISABLE_TEST_LIST = %i(FRAMEWORK_TEST FRAMEWORK_FAIL_TEST SESSION_ESTABLISHMENT INSERTION REMOVAL STATE_TRANSITION PROHIBITED SLEEP INTEGRATION READ)
DISABLE_TEST_LIST = []

$test_name_dict = Hash.new(0)

def get_testfunc_str(testName, preAsicState, preCardState, action, expectedAsicState, expectedCardState, isFailureTest = false, envName = "GcTest")
  # リスト化
  preAsicState = [preAsicState] if not preAsicState.is_a?(Array)
  preCardState = [preCardState] if not preCardState.is_a?(Array)
  expectedAsicState = [expectedAsicState] if not expectedAsicState.is_a?(Array)
  expectedCardState = [expectedCardState] if not expectedCardState.is_a?(Array)
  output_str = ""

  # 組み合わせを出力（action のみ組み合わせには使用しない）
  preAsicState.product(preCardState, expectedAsicState, expectedCardState) do |pas, pcs, eas, ecs|
    eas = pas if eas == nil
    ecs = pcs if ecs == nil
    act = action.is_a?(Array) ? action[0] : action

    # テストの名前
    name = "#{testName}#{pas}#{pcs}#{act}"
    $test_name_dict[name] += 1
    name += $test_name_dict[name].to_s if $test_name_dict[name] > 1

    # EXPECT_DEATH かどうか
    test_beg, test_end = '', ';'
    if ExpectedDeathList.include?(name) then
      test_beg, test_end = 'EXPECT_DEATH_IF_SUPPORTED(', ', "");'
      name += "DeathTest"
    end

    # action が複数だった場合
    preparation = ""
    if action.is_a?(Array) then
      preparation = "    GcAction actionList[] = {#{(action.map{|e| "GcAction_#{e}"}).join(', ')}};\n    int actionListLength = sizeof(actionList) / sizeof(GcAction);\n"
      act_str = "actionList, actionListLength"
    else
      act_str = "GcAction_#{action}"
    end

    # 本文
    output_str << "TEST_F(#{envName}, #{name})\n{\n#{preparation}    #{test_beg}CheckStateAndActionResult(AsicSessionState_#{pas}, GameCardState_#{pcs}, #{act_str}, AsicSessionState_#{eas}, GameCardState_#{ecs}, #{isFailureTest})#{test_end}\n}\n"
  end
  return output_str
end

def conv_sym_to_def(sym)
  return "NN_DETAIL_GC_TEST_#{sym.to_s}_ENABLE"
end

def get_ifdef_str(sym)
  return "#ifdef #{conv_sym_to_def(sym)}\n"
end

def get_define_str(sym)
  return "#define #{conv_sym_to_def(sym)}\n"
end

def get_testsuite_str(name, comment)
  output_str = "// #{comment}\n"
  output_str << get_ifdef_str(name)
  yield output_str
  output_str << "#endif\n\n"
  return output_str
end

def check_area(area_or_mode)
  return :Normal if %i(Normal ReadNormal).include?(area_or_mode)
  return :Secure if %i(Secure ReadSecure).include?(area_or_mode)
  raise "unknown area or mode: " + area_or_mode
end


if $0 == __FILE__ then
  # ヘッダ
  output_str = <<EOS
/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/fsUtil/testFs_util.h>

#include "testGc_Integration_CardInsertionAndRemoval.h"


// *** Ruby script generated code ------------------------------------------------ ***

EOS

  # define の定義
  TEST_LIST.each do |sym|
    output_str << "// " if DISABLE_TEST_LIST.include?(sym)
    output_str << get_define_str(sym)
  end
  output_str << "\n\n"


  # テスト本文
  output_str << get_testsuite_str(:FRAMEWORK_TEST, "テストフレームワークのテスト") do |buf|
    # Initial 状態はすぐに Establishing となるのでテスト省略
    buf << get_testfunc_str( 'TestFrameworkTest', AsicSessionState.reject{|e| %i(Initial Established).include?(e)}, %i(NotInserted Inserted), :None, nil, nil )
    buf << get_testfunc_str( 'TestFrameworkTest', :Established, GameCardState.reject{|e| e == :Debug}, :None, nil, nil )
  end

  output_str << get_testsuite_str(:FRAMEWORK_FAIL_TEST, "テストフレームワークのテスト（異常系）") do |buf|
    buf << get_testfunc_str( 'TestFrameworkFailTest', AsicSessionState.reject{|e| e == :Established}, %i(Normal Secure Debug), :None, nil, nil, FAIL_TSET )
  end

  output_str << get_testsuite_str(:SESSION_ESTABLISHMENT, "セッション構築") do |buf|
    %i(NotInserted Inserted).each do |cs|
      buf << get_testfunc_str( 'StateSessionEstablishment', :Initial, cs, :Wait, :Establishing, cs )
      buf << get_testfunc_str( 'StateSessionEstablishment', [:Establishing, :ReEstablishing], cs, :Wait, :Established, cs )
    end
  end

  output_str << get_testsuite_str(:INSERTION, "挿入バリエーション") do |buf|
    buf << get_testfunc_str( 'StateInsert', *%i(Initial NotInserted InsertCardWait Establishing Inserted) )
    buf << get_testfunc_str( 'StateInsert', %i(Establishing ReEstablishing), :NotInserted, :InsertCardWait, nil, :Inserted )
    buf << get_testfunc_str( 'StateInsert', *%i(Established NotInserted InsertCardWait Established Inserted) )
  end

  output_str << get_testsuite_str(:REMOVAL, "抜去バリエーション") do |buf|
    buf << get_testfunc_str( 'StateRemove', *%i(Initial Inserted RemoveCardWait Establishing NotInserted) )
    buf << get_testfunc_str( 'StateRemove', %i(Establishing ReEstablishing), :Inserted, :RemoveCardWait, nil, :NotInserted )
    buf << get_testfunc_str( 'StateRemove', :Established, %i(Inserted Normal Secure), :RemoveCardWait, :Establishing, :NotInserted )
  end

  output_str << get_testsuite_str(:STATE_TRANSITION, "遷移シーケンス") do |buf|
    buf << get_testfunc_str( 'StateTransition', AsicSessionState, :Inserted, :Activate, :Established, :Normal )
    buf << get_testfunc_str( 'StateTransition', :Established, :Normal, :ChangeSecure, :Established, :Secure )
    buf << get_testfunc_str( 'StateTransition', :Established, %i(Normal Secure), :Activate, :Established, nil )
  end

  output_str << get_testsuite_str(:PROHIBITED, "禁止シーケンス") do |buf|
    buf << get_testfunc_str( 'Prohibited', AsicSessionState, :NotInserted, :Activate, nil, nil, FAIL_TSET )
    buf << get_testfunc_str( 'Prohibited', AsicSessionState, %i(NotInserted Inserted Secure), :ChangeSecure, nil, nil, FAIL_TSET )
  end

  output_str << get_testsuite_str(:SLEEP, "スリープシーケンス") do |buf|
    [:PutToSleep, %i(PutToSleep Awaken), %i(PutToSleep InsertCard Wait3), %i(PutToSleep InsertCard RemoveCard Wait3 Awaken Wait3)].each do |action|
      buf << get_testfunc_str( 'SleepNotInserted', AsicSessionState.reject{|e| %i(Established).include?(e)}, :NotInserted, action, :Established, nil )
    end
    [:PutToSleep, %i(PutToSleep Awaken), %i(PutToSleep RemoveCard Wait3), %i(PutToSleep RemoveCard InsertCard Wait3 Awaken Wait3)].each do |action|
      buf << get_testfunc_str( 'SleepInserted', AsicSessionState.reject{|e| %i(Established).include?(e)}, :Inserted, action, :Established, nil )
    end
    buf << get_testfunc_str( 'SleepInserted', :Established, :Secure, %i(PutToSleep Read), nil, nil, FAIL_TSET )
  end

  output_str << get_testsuite_str(:READ, "リード") do |buf|
    %i(ReadNormal ReadSecure).each do |area|
      [area, %i(PutToSleep Awaken) + [area]].each do |action|
        %i(Normal Secure).each do |mode|
          if check_area(area) != check_area(mode) then
              buf << get_testfunc_str( 'Read', :Established, mode, action, nil, nil, FAIL_TSET )
          else
              buf << get_testfunc_str( 'Read', :Established, mode, action, :Established, nil )
          end            
        end
      end
    end
    buf << get_testfunc_str( 'Read', AsicSessionState, %i(NotInserted Inserted), :Read, nil, nil, FAIL_TSET )
    buf << get_testfunc_str( 'Read', :Established, %i(Normal Secure), %i(RemoveCardWait Read), nil, :NotInserted, FAIL_TSET )
    buf << get_testfunc_str( 'Read', :Established, %i(Normal Secure), %i(RemoveCardWait InsertCardWait Read), nil, :Inserted, FAIL_TSET )
  end

  output_str << get_testsuite_str(:INTEGRATION, "複合シーケンス") do |buf|
    action = %i(InsertCardWait Activate Read PutToSleep Awaken ChangeSecure ReadSecure PutToSleep RemoveCard InsertCard Awaken Wait Activate Read PutToSleep Awaken Deactivate Activate Deactivate PutToSleep Awaken Activate Read ChangeSecure ReadSecure)
    buf << get_testfunc_str( 'Integration', :Initial, :NotInserted, action, :Established, :Secure )
  end

  # 出力
  puts output_str
  File.open(OUTPUT_FILE_PATH, 'wb') {|f| f.write UTF8_BOM }
  File.open(OUTPUT_FILE_PATH, 'a') {|f| f.write output_str }
end
