﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <string>

#include <nn/nn_Log.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/gc/gc.h>
#include <nn/gc/writer/gc_Writer.h>
#include <nn/gc/detail/gc_GcCrypto.h>
#include <nn/gc/detail/gc_EmbeddedDataHolder.h>

#include "SdFileAccessor.h"

char g_TempBuffer[30 * 1024];

// その他必要な修正： #include <nn/gc/detail/gc_GcCrypto.h>, class EmbeddedDataholder の private: -> public:
nn::Result LoadFixedDataFromSdCardAndSetToGcCrypto(char* outBuffer, const size_t bufferLength, const char* filePath)
{
    SdFileAccessor& sdFileAccessor = SdFileAccessor::GetInstance();
    size_t readLength = 0;
    nn::Result result = sdFileAccessor.Read(g_TempBuffer, &readLength, sizeof(g_TempBuffer), filePath);
    if(result.IsFailure())
    {
        return result;
    }

    NN_LOG("Load fixed data from SD card - %s\n", filePath);
    if(readLength != bufferLength)
    {
        NN_LOG("Warning: read file length does not match - %d in SD vs. %d to target\n", readLength, bufferLength);
    }
    else
    {
        NN_LOG("%d bytes read.\n", readLength);
    }
    std::memcpy(outBuffer, g_TempBuffer, bufferLength);

    return nn::ResultSuccess();
}

nn::Result LoadFixedDataFromSdCardAndSetToGcCrypto(void (*copyFunc)(const char*, const size_t), const char* filePath)
{
    SdFileAccessor& sdFileAccessor = SdFileAccessor::GetInstance();
    size_t readLength = 0;
    nn::Result result = sdFileAccessor.Read(g_TempBuffer, &readLength, sizeof(g_TempBuffer), filePath);
    if(result.IsFailure())
    {
        return result;
    }

    NN_LOG("Load fixed data from SD card - %s\n", filePath);
    NN_LOG("%d bytes read.\n", readLength);
    copyFunc(g_TempBuffer, readLength);

    return nn::ResultSuccess();
}

nn::Result LoadFixedDataFromSdCard(const char* folderNameBuffer)
{
    std::string folderPath = "sdcard:/";
    std::string folderName = folderNameBuffer;
    folderPath += folderName;
    folderPath += "/";

    std::string fwName                    = "asic_fw.bin";
    std::string asicCertName              = "asic_cert_veri.crt";
    std::string socCertName               = "soc_cert_veri.crt";
    std::string rnd1Name                  = "RND1.bin";
    std::string rnd2Name                  = "RND2.bin";
    std::string encrnd2Name               = "encRnd2.bin";
    std::string hmacKeyCvName             = "HMAC_SHA256_key_for_CV.bin";
    std::string hmacKeyAesName            = "HMAC_SHA256_key_for_AES.bin";
    std::string CvFixedValueName          = "fixed_value_for_CV.bin";
    std::string oaepLabelName             = "SOC-RSA-OAEP-LABEL.digest.bin";
    std::string rsaKeyModulusName         = "ExtractedRsaKey/SocRsaKeyModulus.bin";
    // TODO: TEMP: TZ 対応で使えなくなった
    // std::string rsaKeyPrivateExponentName = "ExtractedRsaKey/SocRsaKeyPrivateExponent.bin";
    std::string ca1ModulusName            = "ExtractedRsaKey/Ca1Modulus.bin";
    std::string ca1PublicExponentName     = "ExtractedRsaKey/Ca1PublicExponent.bin";

    NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::g_FwReadBuffer, sizeof(nn::gc::detail::EmbeddedDataHolder::g_FwReadBuffer), (folderPath + fwName).c_str() ) );
    // NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::GcCrypto::g_AsicCertBuffer, sizeof(nn::gc::detail::GcCrypto::g_AsicCertBuffer), (folderPath + asicCertName).c_str() ) );
    NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::g_EmmcEmbeddedSocCertificate, sizeof(nn::gc::detail::EmbeddedDataHolder::g_EmmcEmbeddedSocCertificate), (folderPath + socCertName).c_str() ) );

    NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::SetHmacKeyForCvForDebug, (folderPath + hmacKeyCvName).c_str() ) );
    NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::SetHmacKeyForAesForDebug, (folderPath + hmacKeyAesName).c_str() ) );
    NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::SetCvConstantValueForDebug, (folderPath + CvFixedValueName).c_str() ) );

    NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::SetRsaOaepLabel, (folderPath + oaepLabelName).c_str() ) );
    NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::SetSocRsaKeyModulus, (folderPath + rsaKeyModulusName).c_str() ) );
    // NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::SetSocRsaKeyPrivateExponent, (folderPath + rsaKeyPrivateExponentName).c_str() ) );
    NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::SetCa1Modulus, (folderPath + ca1ModulusName).c_str() ) );
    NN_RESULT_DO( LoadFixedDataFromSdCardAndSetToGcCrypto(nn::gc::detail::EmbeddedDataHolder::SetCa1PublicExponent, (folderPath + ca1PublicExponentName).c_str() ) );
    NN_RESULT_SUCCESS;
}

