﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>
#include <nnt/nnt_Argument.h>
#include <nn/fssystem/fs_AsynchronousAccess.h>
#include <nn/fssystem/save/fs_IntegrityVerificationStorage.h>
#include <nn/fssystem/save/fs_BlockCacheBufferedStorage.h>
#include <nn/fssystem/save/fs_JournalIntegritySaveDataFileSystemDriver.h>
#include <nn/crypto.h>
#include <nn/crypto/crypto_HmacGenerator.h>

namespace {

void* Allocate(size_t size) NN_NOEXCEPT
{
    return malloc(size);
}

void Deallocate(void* p, size_t size) NN_NOEXCEPT
{
    NN_UNUSED(size);
    free(p);
}

}

namespace nn { namespace fssystem { namespace save {

lmem::MemoryRange AllocateBuffer(size_t requiredSize, size_t idealSize) NN_NOEXCEPT
{
    NN_UNUSED(idealSize);
    void* ptr = Allocate(requiredSize);
    NN_SDK_ASSERT_NOT_NULL(ptr);
    lmem::MemoryRange memoryRange;
    memoryRange.begin = reinterpret_cast<uintptr_t>(ptr);
    memoryRange.size = requiredSize;
    return memoryRange;
}

void DeallocateBuffer(const lmem::MemoryRange& memoryRange) NN_NOEXCEPT
{
    Deallocate(reinterpret_cast<void*>(memoryRange.begin), memoryRange.size);
}

}}}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    nnt::fs::util::InitializeSaveDataTestHelper();

    nn::fs::SetAllocator(Allocate, Deallocate);
    nn::fssystem::save::HierarchicalIntegrityVerificationStorage::SetGenerateRandomFunction(nnt::fs::util::GenerateRandomForSaveDataTest);

    static const size_t BufferPoolSize = 8 * 1024 * 1024;
    static NN_ALIGNAS(4096) char s_BufferPool[BufferPoolSize];
    nn::fssystem::InitializeBufferPool(s_BufferPool, BufferPoolSize);

    auto result = RUN_ALL_TESTS();

    nnt::fs::util::FinalizeSaveDataTestHelper();

    nnt::Exit(result);
}
