﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testFs_Stress_TestContext.h"

class StressTestMountSdCard : public StressTestMountInfoBase
{
public:
    StressTestMountSdCard() NN_NOEXCEPT
    {
    }

    virtual ~StressTestMountSdCard() NN_NOEXCEPT NN_OVERRIDE
    {
    }

    //! マウント
    void Mount() NN_NOEXCEPT
    {
        NNT_ASSERT_RESULT_SUCCESS(nn::fs::MountSdCardForDebug(GetMountName()));
    }

    //! アンマウント
    void Unmount() NN_NOEXCEPT
    {
        nn::fs::Unmount(GetMountName());
    }

    //! リードオンリーかどうかを取得
    virtual bool IsReadOnly() const NN_NOEXCEPT NN_OVERRIDE
    {
        return false;
    }

    //! FAT への直接アクセスが発生するかどうかを取得
    virtual bool IsAccessesFatDirectly() const NN_NOEXCEPT NN_OVERRIDE
    {
        return true;
    }
};
