﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "testFs_Stress_TestContext.h"

class StressTestMountBis : public StressTestMountInfoBase
{
public:
    StressTestMountBis() NN_NOEXCEPT
    {
    }

    virtual ~StressTestMountBis() NN_NOEXCEPT NN_OVERRIDE
    {
    }

    //! マウント
    void Mount() NN_NOEXCEPT
    {
        SetMountName(nn::fs::GetBisMountName(nn::fs::BisPartitionId::User));
        NNT_ASSERT_RESULT_SUCCESS(
            MountBis(nn::fs::BisPartitionId::User, nullptr)
        );
    }

    //! アンマウント
    void Unmount() NN_NOEXCEPT
    {
        nn::fs::Unmount(GetMountName());
    }
};
