﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testFs_Stress_AccessDirectoriesTestCase.h"

namespace nnt { namespace fs {

namespace {

bool IsFile(int subentryIndex) NN_NOEXCEPT
{
    return (subentryIndex % 2) == 0;
}

}

AccessDirectoriesTestCase::AccessDirectoriesTestCase(
    int threadCount,
    int entryCount,
    int subentryCount) NN_NOEXCEPT
    : OpenEntriesTestCase(threadCount, entryCount, nn::fs::DirectoryEntryType_Directory),
      m_SubentryCount(subentryCount)
{
}

AccessDirectoriesTestCase::~AccessDirectoriesTestCase() NN_NOEXCEPT
{
}

void AccessDirectoriesTestCase::SetUp(FsStressTest* pTest) NN_NOEXCEPT
{
    // ディレクトリを作成する
    OpenEntriesTestCase::SetUp(pTest);
    ASSERT_FALSE(FailedAny());

    ASSERT_LE(GetThreadCount() * GetEntryCount(), FsStressTest::EntryCountMax);
    FailAll();
    for( auto threadIndex = 0; threadIndex < GetThreadCount(); ++threadIndex )
    {
        for( auto entryIndex = 0; entryIndex < GetEntryCount(); ++entryIndex )
        {
            char entryPath[PathLength];
            MakePath(entryPath, GetEntryIndex(threadIndex, entryIndex));

            for( auto subentryIndex = 0; subentryIndex < m_SubentryCount; ++subentryIndex )
            {
                char subentryPath[PathLength];
                nn::util::SNPrintf(
                    subentryPath,
                    sizeof(subentryPath),
                    "%s/sub%d",
                    entryPath,
                    subentryIndex);

                if( pTest->IsReadOnly(GetTestCaseIndex()) )
                {
                    // 子エントリの存在を確認する
                    if( IsFile(subentryIndex) )
                    {
                        nn::fs::FileHandle file;
                        NNT_ASSERT_RESULT_SUCCESS(nn::fs::OpenFile(
                            &file,
                            subentryPath,
                            nn::fs::OpenMode_Read));
                        nn::fs::CloseFile(file);
                    }
                    else
                    {
                        nn::fs::DirectoryHandle directory;
                        NNT_ASSERT_RESULT_SUCCESS(nn::fs::OpenDirectory(
                            &directory,
                            subentryPath,
                            nn::fs::OpenDirectoryMode_All));
                        nn::fs::CloseDirectory(directory);
                    }
                }
                else
                {
                    // 子エントリを作成する
                    nn::Result result;
                    if( IsFile(subentryIndex) )
                    {
                        result = nn::fs::CreateFile(subentryPath, 0);
                    }
                    else
                    {
                        result = nn::fs::CreateDirectory(subentryPath);
                    }
                    if( !nn::fs::ResultPathAlreadyExists::Includes(result) )
                    {
                        NNT_ASSERT_RESULT_SUCCESS(result);
                    }
                }
            }
        }
    }
    SucceedAll();
}

void AccessDirectoriesTestCase::TearDown(FsStressTest* pTest) NN_NOEXCEPT
{
    // ディレクトリを削除する
    OpenEntriesTestCase::TearDown(pTest);
}

}}
