﻿# coding: UTF-8

import os
import random
import shutil
import testpath

CREATE_FILE_BUFFER_SIZE = 1024 * 1024

ResourceFileList = [
    ('/file0.dat', '0x100', 'Zero'),
    ('/dir0/file1.dat', '0x100', 'Zero'),
    ('/BufferAddressAlignmentRo/test.file', '0x800', 'Random'),
    ('/EntryCompositionRo/00/0000.file', '0x400', 'Order'),
    ('/EntryCompositionRo/00/01/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/17/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/17/18/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/17/18/19/test.file', '0x400', 'Random'),
    ('/EntryCompositionRo/00/01/02/03/04/05/06/07/08/09/10/11/12/13/14/15/16/17/18/19/20/test.file', '0x400', 'Random'),
    ('/PathArgumentRo/あ.file', '0x20', 'Zero'),
    ('/PathArgumentRo/あ/dummy', '0x0', 'Zero'),
    ('/PointerArgumentRo/test.file', '0x20', 'Zero'),
    ('/PointerArgumentRo/test/dummy', '0x0', 'Zero'),
    ('/PostConditionRo/test.file', '0x20', 'Random'),
    ('/PostConditionRo/test/test.file', '0x20', 'Zero'),
    ('/PostConditionRo/test/test/dummy', '0x0', 'Zero'),
    ('/PreConditionRo/test.file', '0x20', 'Zero'),
    ('/PreConditionRo/dir/test.file', '0x0', 'Zero'),
    ('/RaceConditionRo/0.file', '0x800', 'Random'),
    ('/RaceConditionRo/1.file', '0x800', 'Zero'),
    ('/ResourceOpenCountRo/Test/0000.file', '0x400', 'Order'),
    ('/ResourceOpenCountRo/Test/00/testEntry.file', '0x0', 'Zero'),
    ('/ResourceOpenCountRo/Test/01/testEntry.file', '0x0', 'Zero'),
    ('/ResourceOpenCountRo/Test/02/testEntry.file', '0x0', 'Zero'),
    ('/ResourceOpenCountRo/Test/03/testEntry.file', '0x0', 'Zero'),
    ('/ResourceOpenCountRo/Test/04/testEntry.file', '0x0', 'Zero'),
    ('/ResourceOpenCountRo/Test/05/testEntry.file', '0x0', 'Zero'),
    ('/SizeArgumentRo/0.file', '0x0', 'Random'),
    ('/SizeArgumentRo/32.file', '0x20', 'Random'),
    ('/SizeArgumentRo/4096.file', '0x1000', 'Random'),
    ('/SizeArgumentRo/16384.file', '0x4000', 'Random'),
    ('/TargetExistenceRo/test.file', '0x0', 'Zero'),
    ('/TargetExistenceRo/testDir/test.file', '0x0', 'Zero'),
    ('/TargetInUseRo/locked.file', '0x0', 'Zero'),
    ('/TargetInUseRo/lockedDir/locked.file', '0x0', 'Zero'),
    ('/MediumSize/1MB_00.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_01.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_02.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_03.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_04.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_05.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_06.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_07.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_08.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_09.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_10.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_11.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_12.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_13.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_14.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_15.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_16.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_17.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_18.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_19.file', '0x100000', 'Random'),
    ('/OrderData/order_00.bin', '0x100000', 'Order'),
    ('/OrderData/order_01.bin', '0x100000', 'Order'),
    ('/OrderData/order_02.bin', '0x100000', 'Order'),
    ('/OrderData/order_03.bin', '0x100000', 'Order'),
    ('/OrderData/order_04.bin', '0x100000', 'Order'),
    ('/OrderData/order_05.bin', '0x100000', 'Order'),
    ('/OrderData/order_06.bin', '0x100000', 'Order'),
    ('/OrderData/order_07.bin', '0x100000', 'Order'),
    ('/OrderData/order_08.bin', '0x100000', 'Order'),
    ('/OrderData/order_09.bin', '0x100000', 'Order'),
    ('/OrderData/order_10.bin', '0x100000', 'Order'),
    ('/OrderData/order_11.bin', '0x100000', 'Order'),
    ('/OrderData/order_12.bin', '0x100000', 'Order'),
    ('/OrderData/order_13.bin', '0x100000', 'Order'),
    ('/OrderData/order_14.bin', '0x100000', 'Order'),
    ('/OrderData/order_15.bin', '0x100000', 'Order'),
    ('/OrderData/order_16.bin', '0x100000', 'Order'),
    ('/OrderData/order_17.bin', '0x100000', 'Order'),
    ('/OrderData/order_18.bin', '0x100000', 'Order'),
    ('/OrderData/order_19.bin', '0x100000', 'Order'),
    ('/OrderData/order_20.bin', '0x100000', 'Order'),
    ('/DirTest/000.file', '0x100000', 'Random'),
    ('/DirTest/001/001.file', '0x100000', 'Random'),
    ('/DirTest/001/002/002.file', '0x100000', 'Random'),
    ('/DirTest/001/012/012.file', '0x100000', 'Random'),
    ('/DirTest/002/001.file', '0x100000', 'Random'),
    ('/DirTest/002/002/002.file', '0x100000', 'Random'),
    ('/DirTest/002/012/012.file', '0x100000', 'Random'),
    ('/DirTest/003/001.file', '0x100000', 'Random'),
    ('/DirTest/003/002/002.file', '0x100000', 'Random'),
    ('/DirTest/003/012/012.file', '0x100000', 'Random')
]

ResourceResizeFileList = [
    ('/MediumSize/1MB_00.file', '0x100000', 'Random'),
    ('/MediumSize/1MB_01.file', '0x200000', 'Random'),
    ('/MediumSize/1MB_02.file', '0x300000', 'Random'),
    ('/MediumSize/1MB_03.file', '0x400000', 'Random'),
    ('/MediumSize/1MB_04.file', '0x500000', 'Random'),
    ('/MediumSize/1MB_05.file', '0x600000', 'Random'),
    ('/MediumSize/1MB_06.file', '0x700000', 'Random'),
    ('/MediumSize/1MB_07.file', '0x800000', 'Random'),
    ('/MediumSize/1MB_08.file', '0x900000', 'Random'),
    ('/MediumSize/1MB_09.file', '0xa00000', 'Random'),
    ('/MediumSize/1MB_10.file', '0xb00000', 'Random'),
    ('/MediumSize/1MB_11.file', '0xc00000', 'Random'),
    ('/MediumSize/1MB_12.file', '0xd00000', 'Random'),
    ('/MediumSize/1MB_13.file', '0xe00000', 'Random'),
    ('/MediumSize/1MB_14.file', '0xf00000', 'Random'),
    ('/MediumSize/1MB_15.file', '0x1000000', 'Random'),
    ('/MediumSize/1MB_16.file', '0x1100000', 'Random'),
    ('/MediumSize/1MB_17.file', '0x1200000', 'Random'),
    ('/MediumSize/1MB_18.file', '0x1300000', 'Random'),
    ('/MediumSize/1MB_19.file', '0x1400000', 'Random')
]

ResourceAddFileList = [
    ('/MediumSize2/1MB_20.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_21.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_22.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_23.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_24.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_25.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_26.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_27.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_28.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_29.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_30.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_31.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_32.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_33.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_34.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_35.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_36.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_37.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_38.file', '0x100000', 'Random'),
    ('/MediumSize2/1MB_39.file', '0x100000', 'Random')
]

ResourceAddDirTestFileList = [
    ('/AddDirTest/001/001.file', '0x100000', 'Order'),
    ('/AddDirTest/002/002.file', '0x100000', 'Order'),
    ('/AddDirTest/002/002/002.file', '0x200000', 'Order'),
    ('/AddDirTest/003/003.file', '0x100000', 'Order'),
    ('/AddDirTest/003/003/003.file', '0x200000', 'Order'),
    ('/AddDirTest/003/003/003/003.file', '0x300000', 'Order'),
    ('/AddDirTest/004/004.file', '0x100000', 'Order'),
    ('/AddDirTest/004/004/004.file', '0x200000', 'Order'),
    ('/AddDirTest/004/004/004/004.file', '0x300000', 'Order'),
    ('/AddDirTest/004/004/004/004/004.file', '0x400000', 'Order'),
    ('/AddDirTest/005/005.file', '0x100000', 'Order'),
    ('/AddDirTest/005/005/005.file', '0x200000', 'Order'),
    ('/AddDirTest/005/005/005/005.file', '0x300000', 'Order'),
    ('/AddDirTest/005/005/005/005/005.file', '0x400000', 'Order'),
    ('/AddDirTest/005/005/005/005/005/005.file', '0x500000', 'Order')
]

ResourceDirTestFileList = [
    ('/DirTest/001/002/002.file', '0x100000', 'Random'),
    ('/DirTest/003/002/002.file', '0x100000', 'Random'),
    ('/DirTest/003/012/012.file', '0x100000', 'Random'),
    ('/DirTest/003/001.file', '0x100000', 'Random')
]

Resource4GFile = ['/SizeArgumentRo/4294967296.file', '0x100000000', 'Random']

MountText = '/mount.txt'

def createMountText():
    if os.path.exists(testpath.ROM_RESOURCE_DIRECTORY_PATH) == False:
        os.makedirs(testpath.ROM_RESOURCE_DIRECTORY_PATH)
    with open(testpath.ROM_RESOURCE_DIRECTORY_PATH + MountText, 'w') as outputFile:
        outputFile.writelines(testpath.ROM_RESOURCE_DIRECTORY_PATH)

def createFileZero(filePath, size):
    with open(filePath, 'wb') as outputFile:
        if size != 0:
            outputFile.seek(size - 1)
            outputFile.write(bytearray([0]))

def createFileRandom(filePath, size):
    with open(filePath, 'wb') as outputFile:
        while outputFile.tell() < size:
            bufferSize = min(size - outputFile.tell(), CREATE_FILE_BUFFER_SIZE)
            writeBuffer = bytearray(bufferSize)
            for i in range(bufferSize):
                writeBuffer[i] = random.randint(0, 255)
            outputFile.write(writeBuffer)

def createFileOrder(filePath, size):
    with open(filePath, 'wb') as outputFile:
        while outputFile.tell() < size:
            bufferSize = min(size - outputFile.tell(), CREATE_FILE_BUFFER_SIZE)
            writeBuffer = bytearray([i % 256 for i in range(bufferSize)])
            outputFile.write(writeBuffer)

def createFile(filePath, size, fileType):
    if fileType.lower() == 'random':
        createFileRandom(filePath, size)
    elif fileType.lower() == 'order':
        createFileOrder(filePath, size)
    else:
        createFileZero(filePath, size)

def changeFileRandom(filePath):
    with open(filePath, 'r+b') as outputFile:
        fileSize = os.path.getsize(filePath)
        outputFile.seek(random.randint(0, fileSize - 1))
        outputFile.write(bytearray([random.randint(0, 255)]))

def cleanRomFs():
    for file in ResourceFileList:
        if os.path.exists(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0]) == True:
            os.remove(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0])
    for file in ResourceAddFileList:
        if os.path.exists(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0]) == True:
            os.remove(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0])
    if os.path.exists(testpath.ROM_RESOURCE_DIRECTORY_PATH + Resource4GFile[0]) == True:
        os.remove(testpath.ROM_RESOURCE_DIRECTORY_PATH + Resource4GFile[0])

def createRomFs():
    romsize = 0
    for file in ResourceFileList:
        dirPath = os.path.dirname(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0])
        if os.path.exists(dirPath) == False:
            os.makedirs(dirPath)
        fileSize = int(file[1], 16)
        romsize += fileSize
        createFile(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0], fileSize, file[2])
    return romsize

def fragmentRomFs(skip):
    delsize = 0
    for i, file in enumerate(ResourceFileList):
        if i % skip is 0:
            if os.path.exists(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0]) == True:
                delsize += int(file[1], 16)
                os.remove(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0])
    return delsize

def resizeRomFs(count):
    resize = 0;
    for i, file in enumerate(ResourceResizeFileList):
        if i < count:
            size = int(file[1], 16);
            resize += size
            filePath = testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0]
            with open(filePath, 'a+b') as outputFile:
                fileSize = os.path.getsize(filePath)
                size += fileSize
                while outputFile.tell() < size:
                    bufferSize = min(size - outputFile.tell(), CREATE_FILE_BUFFER_SIZE)
                    writeBuffer = bytearray(bufferSize)
                    for i in range(bufferSize):
                        writeBuffer[i] = random.randint(0, 255)
                    outputFile.write(writeBuffer)
    return resize

def addRomFs():
    addsize = 0
    for file in ResourceAddFileList:
        dirPath = os.path.dirname(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0])
        if os.path.exists(dirPath) == False:
            os.makedirs(dirPath)
        fileSize = int(file[1], 16)
        addsize += fileSize
        createFile(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0], fileSize, file[2])
    return addsize

def addDirTest():
    addsize = 0
    for file in ResourceAddDirTestFileList:
        dirPath = os.path.dirname(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0])
        if os.path.exists(dirPath) == False:
            os.makedirs(dirPath)
        fileSize = int(file[1], 16)
        addsize += fileSize
        createFile(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0], fileSize, file[2])
    return addsize

def deleteDirTest():
    delsize = 0
    for file in ResourceDirTestFileList:
        os.remove(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0])
        dirPath = os.path.dirname(testpath.ROM_RESOURCE_DIRECTORY_PATH + file[0])
        os.rmdir(dirPath)
        delsize += int(file[1], 16)
    return delsize

def create4GFile():
    if os.path.exists(testpath.ROM_RESOURCE_TMP_DIRECTORY_PATH + Resource4GFile[0]) == True:
        shutil.copy(testpath.ROM_RESOURCE_TMP_DIRECTORY_PATH + Resource4GFile[0], testpath.ROM_RESOURCE_DIRECTORY_PATH + Resource4GFile[0])
    else:
        fileSize = int(Resource4GFile[1], 16)
        createFile(testpath.ROM_RESOURCE_DIRECTORY_PATH + Resource4GFile[0], fileSize, Resource4GFile[2])
    return 4 * 1024 * 1024 * 1024

def delete4GFile():
    delsize = 0
    if os.path.exists(testpath.ROM_RESOURCE_DIRECTORY_PATH + Resource4GFile[0]) == True:
        os.remove(testpath.ROM_RESOURCE_DIRECTORY_PATH + Resource4GFile[0])
        delsize = 4 * 1024 * 1024 * 1024
    return delsize
