﻿# coding: UTF-8

import os
import sys

SIGLO_ROOT            = os.path.normpath(os.path.dirname(os.path.abspath(__file__)) + '/../../../../../..')
NACT_PATH             = os.path.normpath(SIGLO_ROOT + '/Integrate/CommandLineTools/nact.exe')
RUN_ON_TARGET_PATH    = os.path.normpath(SIGLO_ROOT + '/Tools/CommandLineTools/RunOnTarget.exe')
CONTROL_TARGET_PATH   = os.path.normpath(SIGLO_ROOT + '/Tools/CommandLineTools/ControlTarget.exe')
AUTHORING_TOOL_PATH   = os.path.normpath(SIGLO_ROOT + '/Tools/CommandLineTools/AuthoringTool/AuthoringTool.exe')
COMMON_RESOURCE_PATH  = os.path.normpath(SIGLO_ROOT + '/Tests/Common/Resources')
META_BASE_FILE_PATH   = os.path.normpath(COMMON_RESOURCE_PATH + '/TestApplication.aarch64.lp64.nmeta')
DESC_FILE_PATH        = os.path.normpath(COMMON_RESOURCE_PATH + '/TestApplication.autogen.desc')
g_DevMenuCommandPath  = os.path.normpath(SIGLO_ROOT + '/Programs/Eris/Outputs/NX-NXFP2-a64/TargetTools/DevMenuCommand/Release/DevMenuCommand.nsp')

g_ResourceDirectoryPath = ''
g_OutputDirectoryPath   = ''


def updatePath(platform, buildType, testName):
    global g_DevMenuCommandPath, g_OutputDirectoryPath, g_ResourceDirectoryPath
    g_DevMenuCommandPath = os.path.normpath(os.path.join(SIGLO_ROOT, 'Programs/Eris/Outputs', platform, 'TargetTools/DevMenuCommand', buildType, 'DevMenuCommand.nsp'))
    g_OutputDirectoryPath = os.path.normpath(os.path.join(SIGLO_ROOT, 'Tests/Outputs', platform, 'Tests', 'testFs_' + testName, buildType))
    g_ResourceDirectoryPath = os.path.normpath(os.path.join(SIGLO_ROOT, 'Tests/Resources/Fs', testName))

def printf(format, *args):
    sys.stdout.write((format + '\n') % args)
    sys.stdout.flush()
