﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/fs/fs_SaveDataManagementPrivate.h>

#include <nnt/nntest.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/fsUtil/testFs_util.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/nnt_Argument.h>

using namespace nn;
using namespace nn::fs;
using namespace nn::fs::detail;
using namespace nnt::fs::util;

namespace {

const SystemSaveDataId NcmSystemSaveDataIdArray[] = {
    0x8000000000000120ULL,
    0x8000000000000121ULL,
};

// SIGLO-76586: 不正な ownerId の状態にする
TEST(FixNcmSystemSaveDataOwnerId, SetToIncorrectId)
{
    const Bit64 InCorrectNcmOwnerId = 0x0100000000002104ULL;

    for (auto id : NcmSystemSaveDataIdArray)
    {
        SaveDataExtraData extraData;
        memset(&extraData, 0x00, sizeof(extraData));
        extraData.ownerId = InCorrectNcmOwnerId;

        SaveDataExtraData extraDataMask;
        memset(&extraDataMask, 0x00, sizeof(extraDataMask));
        extraDataMask.ownerId = 0xFFFFFFFFFFFFFFFFULL;

        NNT_EXPECT_RESULT_SUCCESS(WriteSaveDataFileSystemExtraData(SaveDataSpaceId::System, id, extraData, extraDataMask));
    }
}

// 再起動で OwnerId が正しい値に修正されていること
// @pre FixNcmSystemSaveDataOwnerId.SetToIncorrectId の実行後、再起動
TEST(FixNcmSystemSaveDataOwnerId, CheckId)
{
    const Bit64 CorrectNcmOwnerId = 0;

    for (auto id : NcmSystemSaveDataIdArray)
    {
        SaveDataExtraData extraData;
        NNT_EXPECT_RESULT_SUCCESS(ReadSaveDataFileSystemExtraData(&extraData, SaveDataSpaceId::System, id));
        EXPECT_EQ(CorrectNcmOwnerId, extraData.ownerId);
    }
}

}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);
    nnt::fs::util::ResetAllocateCount();

    auto result = RUN_ALL_TESTS();

    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    nnt::Exit(result);
}

