﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_RegisteredUpdatePartition.h>

#include "testFs_FsLib_Mount.h"

namespace
{
    const nnt::fs::util::MountTestAttribute GetAttribute() NN_NOEXCEPT
    {
        nnt::fs::util::MountTestAttribute attribute = {};
        attribute.isReservedMountNameSupported = true;
        return attribute;
    }

    nn::Result MountRegisteredUpdatePartitionForMountNameTest(const char* mountName) NN_NOEXCEPT
    {
        nn::fs::RegisterUpdatePartition();
        NN_RESULT_DO(nn::fs::MountRegisteredUpdatePartition(mountName));
        NN_RESULT_SUCCESS;
    }

    const nnt::fs::util::MountTestParameter MountTestParameters[] = {
        { "MountRegisteredUpdatePartition", MountRegisteredUpdatePartitionForMountNameTest, nullptr, GetAttribute },
    };
}

NNT_FS_INSTANTIATE_TEST_CASE_MOUNT(WithMountRegisteredUpdatePartition, ::testing::ValuesIn(MountTestParameters));
