﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/fs.h>

#include <nn/fs/fs_ResultHandler.h>

#include <nnt/nntest.h>
#include <nnt/nnt_Argument.h>
#include <nnt/base/testBase_Exit.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/fsUtil/testFs_util.h>

// nninitStartup() を定義しつつ nn::init::InitializeAllocator() しないアプリで SetAllocator を行う

TEST(Allocator, UseSetAllocator)
{
    // gtest_repeat を使って 2 回以上実行された場合、2回目以降はテストをスキップする
    static bool s_IsExecuted = false;
    NNT_FS_UTIL_SKIP_TEST_UNLESS( !s_IsExecuted );
    s_IsExecuted = true;

    nn::fs::SetAllocator(nnt::fs::util::Allocate, nnt::fs::util::Deallocate);

    NNT_EXPECT_RESULT_SUCCESS(nn::fs::MountHostRoot());
    nn::fs::UnmountHostRoot();
}

extern "C" void nninitStartup()
{
    NN_LOG("malloc disabled by %s %d\n", __FUNCTION__, __LINE__);

    const size_t MemoryHeapSize = 1024 * 1024 * 1024;
    nn::os::SetMemoryHeapSize( MemoryHeapSize );
}

extern "C" void nnMain()
{
    int     argc = nnt::GetHostArgc();
    char**  argv = nnt::GetHostArgv();

    ::testing::InitGoogleTest(&argc, argv);
    nn::fs::SetEnabledAutoAbort(false);
    nnt::fs::util::ResetAllocateCount();

    auto testResult = RUN_ALL_TESTS();

    if (nnt::fs::util::CheckMemoryLeak())
    {
        nnt::Exit(1);
    }

    nnt::Exit(testResult);
}
