﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/account/account_Api.h>
#include <nn/fs/fs_AccessLogPrivate.h>
#include <nn/fs/fs_Utility.h>

#include <nnt/fsUtil/testFs_util_function.h>

namespace nnt { namespace fs
{
    const nn::ncm::ApplicationId ApplicationId = { 0x0100000000003006 };
    const nn::ncm::ApplicationId InvalidApplicationId = { 0x9876543210987654 };
    const char* const MountName = "test";
    const char* const InvalidMountName = "invalid";
    extern nnt::fs::util::String g_RomFilePath;

    nn::account::Uid GetDefaultUid() NN_NOEXCEPT;
    nn::fs::UserId GetDefaultFsUid() NN_NOEXCEPT;
    nn::fs::SaveDataId GetSaveDataId(nn::account::Uid uid) NN_NOEXCEPT;
    nn::fs::SaveDataId GetSaveDataId(nn::fs::UserId userId) NN_NOEXCEPT;
}}

/*
テスト終了時の、期待するアクセスログ
AccessLogTest: NX
AccessLogTest: NX-system
AccessLogTest: Generic
AccessLogTest: Generic-system
*/
