﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/fsApiRo/testFs_ApiRo.h>

namespace nnt { namespace fs { namespace api {
    void LoadOperateRangeRoTests()
    {
        return;
    }

    class OperateRangeRo : public GetFileSystemTestFixture
    {
    protected:
        virtual void SetUp() NN_NOEXCEPT NN_OVERRIDE
        {
            GetFileSystemTestFixture::SetUp();
            m_FileName = GetTestRootPath().append("/OperateRangeRo/test.file");
        }
        virtual void TearDown() NN_NOEXCEPT NN_OVERRIDE
        {
            GetFileSystemTestFixture::TearDown();
        }

        const nnt::fs::util::String& GetFileName() NN_NOEXCEPT
        {
            return m_FileName;
        }

    private:
        nnt::fs::util::String m_FileName;
    };

    //!< @brief QueryRange の挙動が正しく動作していること
    TEST_F(OperateRangeRo, QueryRange)
    {
        // ファイルオープン
        std::unique_ptr<ITestFile> file;

        NNT_ASSERT_RESULT_SUCCESS(
            GetFs().OpenFile(
                &file,
                GetFileName().c_str(),
                static_cast<nn::fs::OpenMode>(nn::fs::OpenMode::OpenMode_Read)
            )
        );

        int64_t size;
        NNT_ASSERT_RESULT_SUCCESS(file->GetSize(&size));

        nn::fs::QueryRangeInfo info;

        if( GetFsAttribute()->isSupportedQueryRange )
        {
            NNT_ASSERT_RESULT_SUCCESS(file->QueryRange(&info, 0, size));
            EXPECT_EQ(GetFsAttribute()->aesCtrKeyTypeFlag, info.aesCtrKeyTypeFlag);
            EXPECT_EQ(GetFsAttribute()->speedEmulationTypeFlag, info.speedEmulationTypeFlag);
        }
        else
        {
            NNT_ASSERT_RESULT_FAILURE(nn::fs::ResultUnsupportedOperation,
                file->QueryRange(&info, 0, size));
        }
    }

}}}
