﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/os.h>
#include <nn/nn_Log.h>
#include <nn/erpt.h>
#include <nn/erpt/erpt_Manager.h>
#include <nn/eupld/eupld_Request.h>
#include <nn/eupld/eupld_Control.h>
#include <nn/time/time_Api.h>
#include <nn/time/time_StandardUserSystemClock.h>
#include <nnt.h>

namespace nnt   {
namespace eupld {
namespace       {

int g_ReportsToGenerate = 0;

}

TEST(eupld, SetUrl)
{
    nn::Result         result;
    nn::eupld::Control control;
    const char         tmpUrl[] = "https://receive-%.er.srv.nintendo.net/post";

    result = control.SetUrl(tmpUrl, static_cast<uint32_t>(strlen(tmpUrl) + 1));
    NNT_EXPECT_RESULT_SUCCESS(result);
}

TEST(eupld, GenerateReports)
{
    nn::Result result;
    const char errorCode[] = "1234-1234";

    for (int reportCount = 0;
             reportCount < g_ReportsToGenerate;
             reportCount++)
    {
        nn::erpt::Context  context(nn::erpt::ErrorInfo);

        result = context.Add(nn::erpt::ErrorCode, errorCode, sizeof(errorCode));
        NNT_EXPECT_RESULT_SUCCESS(result);

        if ((reportCount & 0x1))
        {
            result = context.Add(nn::erpt::AbortFlag, true);
            NNT_EXPECT_RESULT_SUCCESS(result);
        }

        result = context.CreateReport(nn::erpt::ReportType_Invisible);
        NNT_EXPECT_RESULT_SUCCESS(result);

        NN_LOG(".");
    }
}

extern "C" void nnMain()
{
    char** argV;
    int    argC;
    int    result;

    argC = nnt::GetHostArgc();
    argV = nnt::GetHostArgv();

    if (argC > 1)
    {
        g_ReportsToGenerate = std::strtoul(argV[1], nullptr, 10);
    }
    else
    {
        g_ReportsToGenerate = 1;
    }

    ::testing::InitGoogleTest(&argC, argV);
    result = RUN_ALL_TESTS();
    nnt::Exit(result);
}

}}
