﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#include <nnt/nntest.h>
#include <nn/nn_Log.h>
#include <nn/escore/escore.h>
#include <nnt/escoreUtil/testEscore_util_istorage.h>

USING_ESCORE_UTIL_NAMESPACE
USING_ES_NAMESPACE
USING_ISTORAGE_NAMESPACE

#include "../Common/testEs_Est_utils.h"

#include "../Common/testEs_Tkt6.cpp"


/* Global object for the ticket and TMD */
static ETicket __ticket;


static ESError __testReadTicket()
{
    ESError rv = ES_ERR_OK;
    MemoryInputStream ticketReader( tkt6, sizeof( tkt6 ) );
    u32 ticketSize;

    /*
     * The read test uses the read-only eTicket and TMD classes to
     * demonstrate their usage on the ARM11.  It performs the
     * following steps:
     *
     *  1) Set the ticket
     *  2) Get the ticket size
     *
     * The APIs on the ARM11 are exactly the same as the APIs on the
     * ARM9.  The main difference is that verification is not supported
     * on the ARM11
     */

    ES_TEST_LOG( "*** Start read ticket test ***\n" );

    /* Step 1: Set the ticket */
    rv = __ticket.Set( ticketReader, NULL, 0, false );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to set and verify ticket, rv=%d\n", rv );
        goto end;
    }
    ES_TEST_LOG( "Set and verified ticket\n" );

    /* Step 2: Get the size */
    rv = __ticket.GetSize( &ticketSize );
    if( rv != ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed to get ticket size, rv=%d\n", rv );
        goto end;
    }
    ES_TEST_LOG( "Retrieved ticket size, %d\n", ticketSize );

    /*
     * Step 3: negative test
     *
     * Setting "doVerify" should fail
     */
    rv = __ticket.Set( ticketReader, NULL, 0, true );
    if( rv == ES_ERR_OK )
    {
        ES_TEST_LOG( "Failed: ticket set with verify, rv=%d\n", rv );
        rv = ES_ERR_INVALID;
        goto end;
    }
    ES_TEST_LOG( "Passed:  previous failure was expected\n" );

    ES_TEST_LOG( "*** Completed read ticket test ***\n" );
    rv = ES_ERR_OK;

end:
    return rv;
}

TEST( ReadOnlyTest, ReadOnly )
{
    ESError rv = ES_ERR_OK;

    rv = __testReadTicket();
    EXPECT_EQ( rv, ES_ERR_OK );
    if( rv != ES_ERR_OK )
    {
        goto end;
    }

    ES_TEST_LOG( "*** Passed ES readonly tests ***\n" );

end:
    return;
}
