﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2008, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#pragma once

#include <nnt/nntest.h>

//#include <types.h>
#include <nn/iosc/iosc.h>

#ifdef LINUX
#include <cstdio>
#include <cstring>
#include <cstdlib>
#else
#include <nn/ioslibc/ioslibc.h>
#endif

#include "testEs_Testutils.h"

#define CHECK_RETURN( err, val, msg )                                 \
    EXPECT_EQ( err, val );                                            \
    if( err != val )                                                  \
    {                                                                 \
        TUL_LogFail( TESTNAME, "%s failed with error %d", msg, err ); \
    }

#define CHECK_EQUAL( err, val, msg )  \
    EXPECT_EQ( err, val );            \
    if( err != val )                  \
    {                                 \
        TUL_LogFail( TESTNAME, msg ); \
        EXIT( -1 );                   \
    }

#define CHECK_NOT_EQUAL( err, val, msg ) \
    if( err == val )                     \
    {                                    \
        TUL_LogFail( TESTNAME, msg );    \
        ADD_FAILURE();                   \
        EXIT( -1 );                      \
    }                                    \
    else                                 \
    {                                    \
        SUCCEED();                       \
    }

#define LOG_MESSAGE( msg, ... )                     \
    do                                              \
    {                                               \
        TUL_LogPrint( TESTNAME, msg, ##__VA_ARGS__ ); \
    } while( 0 )

#define LOG_PASS( msg, ... )                       \
    do                                             \
    {                                              \
        TUL_LogPass( TESTNAME, msg, ##__VA_ARGS__ ); \
        SUCCEED();                                 \
    } while( 0 )

#define LOG_FAIL( msg, ... )                       \
    do                                             \
    {                                              \
        TUL_LogFail( TESTNAME, msg, ##__VA_ARGS__ ); \
        ADD_FAILURE();                             \
    } while( 0 )

#define EXIT( status ) \
    ADD_FAILURE();     \
    TUL_Exit( TESTNAME )

#if defined( LINUX )
#define ALIGN_SIZE 16 // NOLINT(readability/define)
#elif defined( SDK_TWL )
#define ALIGN_SIZE 32 // NOLINT(readability/define)
#else
#define ALIGN_SIZE 64 // NOLINT(readability/define)
#endif

#ifdef RVL
#include <iop.h>
const int NUM_TICKS = 128;
const int CLOCK_FREQ = 243;
extern u32 getNumTicks( u32, u32 );
#endif

#ifdef NET_CARD
#include <sc.h>
const u8 _initStack[STACK_SIZE];
const u32 _initStackSize = sizeof( _initStack );
const u32 _initPriority = 10;
#ifdef NEED_NUMTICKS
const int NUM_TICKS = 200;
const int CLOCK_FREQ = 100;

static u32 getNumTicks( u32 start, u32 end )
{
    u32 diff;
    diff = ( end >= start ) ? end - start : end + ( 0xFFFFFFFF - start );
    return diff;
}
#endif /* NEED_NUMTICKS */
#endif /* NET_CARD */

#if defined( MEASURE_PERF )
/* Performance measurement for TWL (or Nitro) */

static OSTick ticks;
static u64 mSec;
static u32 mSecLo;

#define PERF_START()          \
    do                        \
    {                         \
        ticks = OS_GetTick(); \
    } while( 0 )
#define PERF_END( str )                                      \
    do                                                       \
    {                                                        \
        ticks = OS_GetTick() - ticks;                        \
        mSec = OS_TicksToMilliSeconds( ticks );              \
        mSecLo = ( u32 )( mSec & 0xffffffffULL );            \
        TUL_LogPrint( str, "PERF %d milliseconds", mSecLo ); \
    } while( 0 )

#else /* !MEASURE_PERF */

#define PERF_START()
#define PERF_END( str )

#endif /* !MEASURE_PERF */
