﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2008, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#include <nnt/nntest.h>
#include <nn/nn_Macro.h>

#define TESTNAME "EccRefTest"

#include "testEs_Testcommon.h"
#include <nn/ioscrypto/iosccert.h>

NN_ALIGNAS( ALIGN_SIZE ) static IOSCEccSignedCert appcert;

#ifdef USE_OBSOLETE_CODE
IOSError createEncryptedRandomsEccRef( IOSCSecretKeyHandle handle, u8 *iv, u8 *rand, u32 size )
{
    IOSCError error;
    int i;
    /* Encrypt randoms - somewhere else ! */
    for( i = 0; i < size; i++ )
    {
        rand[i] = i;
    }
    for( i = 0; i < sizeof( IOSCAesIv ); i++ )
    {
        iv[i] = i + 1;
    }
    error = IOSC_Encrypt( handle, iv, rand, size, rand );
    if( error != IOSC_ERROR_OK )
    {
        return error;
    }
    /* reset IV */
    for( i = 0; i < sizeof( IOSCAesIv ); i++ )
    {
        iv[i] = i + 1;
    }
    return error;
}
#endif

extern int doEccRefTest( void );

int doEccRefTest()
{
    IOSCSecretKeyHandle privkeyh1, privkeyh2;
    IOSCSecretKeyHandle sharedkeyh1, sharedkeyh2;
    IOSCPublicKeyHandle pubkeyh1, pubkeyh2;
    IOSCError error;
    IOSCCertName appname;
    IOSCAesKey sharedKey1, sharedKey2;

    IOSCEccPrivateKey privKey1, privKey2;
    IOSCEccPublicKey pubKey1;
    IOSCAesKey sharedKeyRef;
    int iter;


    /* First data set */
    u8 privKey1_first[] = {0x00, 0x76, 0xe5, 0xfa, 0x76, 0xa8, 0xad, 0xbe, 0x9d, 0xbd, 0x96, 0x4a, 0x09, 0xf2, 0xd5,
                           0xd0, 0x85, 0x6a, 0x6a, 0x45, 0x8c, 0x9d, 0x8f, 0x49, 0x9f, 0x04, 0xaf, 0xee, 0x68, 0xe2};
    u8 pubKey1_first[] = {0x01, 0xcf, 0x00, 0xce, 0x2c, 0x85, 0x08, 0xbf, 0x5a, 0x7f, 0x98, 0x7a, 0x25, 0x99, 0xc3, 0xc8, 0x03, 0x1c, 0xf7, 0xce,
                          0x06, 0x9d, 0x0b, 0x90, 0x0b, 0x2a, 0xfc, 0x31, 0x75, 0x24, 0x00, 0xd0, 0xeb, 0xfb, 0xec, 0xc7, 0x31, 0xe8, 0xf7, 0x6c,
                          0x35, 0x73, 0x1b, 0xb0, 0xed, 0x35, 0xf8, 0x9d, 0x65, 0x5a, 0x6a, 0x6a, 0x44, 0xce, 0x2f, 0x6a, 0x47, 0xfb, 0x45, 0x39};
    u8 privKey2_first[] = {0x00, 0x49, 0xF2, 0x3F, 0x59, 0x9E, 0x5D, 0xD6, 0xBE, 0x39, 0x4C, 0x19, 0x9B, 0xC9, 0x58,
                           0x3B, 0x30, 0xA5, 0xA2, 0x45, 0x25, 0x10, 0xA9, 0xF9, 0xA7, 0x6F, 0xA1, 0x73, 0x3D, 0xA1};
    u8 sharedKeyRef_first[] = {0x8a, 0x22, 0xb5, 0x18, 0x19, 0xce, 0xa9, 0xdc, 0x7b, 0x8b, 0x23, 0xd2, 0x4e, 0x11, 0xed, 0x1b};

    /* Second data set */
    u8 privKey1_second[] = {0x00, 0x02, 0x0B, 0xD9, 0xA4, 0x6A, 0xF9, 0xCD, 0x8B, 0x9F, 0xDA, 0x73, 0xA4, 0x79, 0x4F,
                            0xD0, 0x15, 0x3E, 0x10, 0x56, 0xAE, 0x84, 0xDA, 0x80, 0x23, 0xDB, 0xA6, 0x61, 0xAD, 0xE3};
    u8 pubKey1_second[] = {0x00, 0x33, 0xFC, 0xC2, 0x46, 0x4D, 0x0B, 0x32, 0x8C, 0xB0, 0x8D, 0x7A, 0x73, 0xA4, 0x6D, 0x52, 0x58, 0x54, 0x46, 0xB6,
                           0xB2, 0xE4, 0x4C, 0xEF, 0x2F, 0x62, 0x4E, 0xF8, 0xED, 0x34, 0x01, 0x2B, 0x16, 0xA2, 0x54, 0xDA, 0x53, 0xDF, 0x13, 0xE6,
                           0x6A, 0x16, 0xA3, 0x20, 0xC5, 0x2D, 0xD7, 0x1C, 0x51, 0x73, 0x38, 0xCD, 0x97, 0xD2, 0x9D, 0x10, 0xD5, 0xC8, 0xBB, 0x73};
    u8 privKey2_second[] = {0x00, 0x0D, 0xEB, 0xC4, 0x92, 0xFD, 0x83, 0xA7, 0xCC, 0xDF, 0x4B, 0xF9, 0x57, 0xF4, 0xAC,
                            0x74, 0xF8, 0xD1, 0x5A, 0xE1, 0x2F, 0x59, 0x40, 0xB0, 0xED, 0xE9, 0x5D, 0x7A, 0x77, 0x74};
    u8 sharedKeyRef_second[] = {0x4C, 0xBB, 0x4D, 0xED, 0x32, 0x40, 0x32, 0x4A, 0x84, 0x1D,
                                0x93, 0x15, 0xDE, 0x74, 0xA3, 0x2B, 0x16, 0xEC, 0x57, 0x31};
    /* Third data set */
    u8 privKey1_third[] = {0x00, 0xF7, 0x8D, 0xA7, 0x45, 0x6C, 0x3E, 0x35, 0x00, 0xE5, 0xFC, 0xEB, 0x51, 0x64, 0x74,
                           0x49, 0x04, 0xF6, 0xFA, 0x3F, 0x84, 0xC0, 0xAB, 0xAD, 0x9B, 0x70, 0xCD, 0x3E, 0x90, 0x22};
    u8 pubKey1_third[] = {0x01, 0x6E, 0x80, 0x23, 0xC2, 0xFA, 0xAF, 0xB0, 0xD9, 0x01, 0xE7, 0xDA, 0x4D, 0x80, 0x27, 0xB3, 0x93, 0x4C, 0xAA, 0xA8,
                          0x0D, 0x4A, 0xB4, 0x27, 0x20, 0x40, 0x77, 0x5B, 0xEA, 0xA4, 0x01, 0x8A, 0xBB, 0xB9, 0xC9, 0x71, 0x27, 0x0C, 0x12, 0xBC,
                          0x41, 0x02, 0x71, 0x3B, 0x25, 0x27, 0xD7, 0xCB, 0xF9, 0xDE, 0xD7, 0x6D, 0xD7, 0x71, 0x92, 0xE7, 0xF8, 0x01, 0xAB, 0xE2};
    u8 privKey2_third[] = {0x00, 0xCF, 0xB6, 0xDC, 0xD1, 0x1A, 0x88, 0x4A, 0x7D, 0xD8, 0xCE, 0xE4, 0x4D, 0xE9, 0x54,
                           0x29, 0x8C, 0x40, 0x71, 0x3D, 0xF9, 0x81, 0xE7, 0x27, 0xA3, 0xF5, 0x88, 0x14, 0xE8, 0xF7};
    u8 sharedKeyRef_third[] = {0xE2, 0x08, 0xFB, 0x3A, 0xF2, 0xD3, 0x9B, 0x4B, 0xF5, 0xCF,
                               0x82, 0x13, 0xEC, 0xB4, 0x5B, 0xA8, 0x17, 0x52, 0x9D, 0x3C};

    for( iter = 0; iter < 5; iter++ )
    {
        if( iter == 0 )
        {
            memcpy( privKey1, privKey1_first, sizeof( IOSCEccPrivateKey ) );
            memcpy( pubKey1, pubKey1_first, sizeof( IOSCEccPublicKey ) );
            memcpy( privKey2, privKey2_first, sizeof( IOSCEccPrivateKey ) );
            memcpy( sharedKeyRef, sharedKeyRef_first, sizeof( IOSCAesKey ) );
        }
        if( iter == 1 )
        {
            memcpy( privKey1, privKey1_second, sizeof( IOSCEccPrivateKey ) );
            memcpy( pubKey1, pubKey1_second, sizeof( IOSCEccPublicKey ) );
            memcpy( privKey2, privKey2_second, sizeof( IOSCEccPrivateKey ) );
            memcpy( sharedKeyRef, sharedKeyRef_second, sizeof( IOSCAesKey ) );
        }
        if( iter == 2 )
        {
            memcpy( privKey1, privKey1_third, sizeof( IOSCEccPrivateKey ) );
            memcpy( pubKey1, pubKey1_third, sizeof( IOSCEccPublicKey ) );
            memcpy( privKey2, privKey2_third, sizeof( IOSCEccPrivateKey ) );
            memcpy( sharedKeyRef, sharedKeyRef_third, sizeof( IOSCAesKey ) );
        }
        if( iter == 3 )
        {
            /* Negative Test */
            memcpy( privKey1, privKey1_third, sizeof( IOSCEccPrivateKey ) );
            memcpy( pubKey1, pubKey1_third, sizeof( IOSCEccPublicKey ) );
            memcpy( privKey2, privKey2_third, sizeof( IOSCEccPrivateKey ) );
            memcpy( sharedKeyRef, sharedKeyRef_third, sizeof( IOSCAesKey ) );
            /* change priv key 2 */
        }
        if( iter == 4 )
        {
            /*Negative Test */
            memcpy( privKey1, privKey1_third, sizeof( IOSCEccPrivateKey ) );
            memcpy( pubKey1, pubKey1_third, sizeof( IOSCEccPublicKey ) );
            memcpy( privKey2, privKey2_third, sizeof( IOSCEccPrivateKey ) );
            memcpy( sharedKeyRef, sharedKeyRef_third, sizeof( IOSCAesKey ) );
            /* change pub key 2  later */
        }

        /*
         * Test of public key generation compared to reference
         */
        error = IOSC_CreateObject( &privkeyh1, IOSC_SECRETKEY_TYPE, IOSC_ECC233_SUBTYPE );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "CreateObject error" );
        error = IOSC_ImportSecretKey( privkeyh1, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, privKey1 );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "ImportSecretKey error" );
        /* import public keys: get them by getting certs */
        memset( appname, 0x0, sizeof( IOSCCertName ) );
        memcpy( appname, "APP00000001", sizeof( "APP00000001" ) );
#ifdef USE_OBSOLETE_CODE
#ifdef RVL
        error = createEncryptedRandomsEccRef( IOSC_COMMON_ENC_HANDLE, ivData, randBuffer, sizeof( randBuffer ) );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "CreateRandoms error" );
        error = IOSC_GenerateCertificateWithRandoms( privkeyh1, appname, &appcert, ivData, randBuffer, IOSC_COMMON_ENC_HANDLE );
#endif
#else
        error = IOSC_GenerateCertificate( privkeyh1, appname, &appcert );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "GenerateCertificate error" );
#endif

        /* compare public key with reference */
        if( memcmp( (u8 *)pubKey1, (u8 *)( ( (IOSCEccEccCert *)appcert )->pubKey ), sizeof( IOSCEccPublicKey ) ) == 0x0 )
        {
            LOG_PASS( "IOSC ECC Generate Public Key Ref Test" );
        }
        else
        {
            LOG_FAIL( "IOSC ECC Generate Public Key Ref Test" );
            EXIT( -1 );
        }

        /* Test of shared key */
        /* Second key pair */
        error = IOSC_CreateObject( &privkeyh2, IOSC_SECRETKEY_TYPE, IOSC_ECC233_SUBTYPE );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "CreateObject error" );
        error = IOSC_ImportSecretKey( privkeyh2, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, privKey2 );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "ImportSecretKey error" );
        /* import public keys: get them by getting certs */
        memset( appname, 0x0, sizeof( IOSCCertName ) );
        memcpy( appname, "APP00000001", sizeof( "APP00000001" ) );
#ifdef USE_OBSOLETE_CODE
#ifdef RVL
        error = createEncryptedRandomsEccRef( IOSC_COMMON_ENC_HANDLE, ivData, randBuffer, sizeof( randBuffer ) );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "CreateRandoms error" );
        error = IOSC_GenerateCertificateWithRandoms( privkeyh2, appname, &appcert, ivData, randBuffer, IOSC_COMMON_ENC_HANDLE );
#endif
#else
        error = IOSC_GenerateCertificate( privkeyh2, appname, &appcert );
#endif
        CHECK_EQUAL( error, IOSC_ERROR_OK, "GenerateCertificate error" );

        /* import public keys */
        error = IOSC_CreateObject( &pubkeyh1, IOSC_PUBLICKEY_TYPE, IOSC_ECC233_SUBTYPE );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "CreateObject error" );
        error = IOSC_ImportPublicKey( pubKey1, 0, pubkeyh1 );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "ImportSecretKey error" );

        error = IOSC_CreateObject( &pubkeyh2, IOSC_PUBLICKEY_TYPE, IOSC_ECC233_SUBTYPE );

        /* introduce error for neg test */
        if( iter == 4 )
        {
            ( ( (IOSCEccEccCert *)appcert )->pubKey[16] ) ^= 0x01;
        }
        CHECK_EQUAL( error, IOSC_ERROR_OK, "CreateObject error" );
        error = IOSC_ImportPublicKey( ( ( (IOSCEccEccCert *)appcert )->pubKey ), 0, pubkeyh2 );

        CHECK_EQUAL( error, IOSC_ERROR_OK, "ImportPublicKey error" );
        /* introduce error for neg test */
        if( iter == 3 )
        {
            privKey2[7] ^= 0x1;
            /* import it for computing shared key */
            error = IOSC_ImportSecretKey( privkeyh2, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, privKey2 );
            CHECK_EQUAL( error, IOSC_ERROR_OK, "ImportSecretKey error" );
        }

        /* compute shared keys */
        error = IOSC_CreateObject( &sharedkeyh1, IOSC_SECRETKEY_TYPE, IOSC_ENC_SUBTYPE );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "CreateObject error" );

        error = IOSC_CreateObject( &sharedkeyh2, IOSC_SECRETKEY_TYPE, IOSC_ENC_SUBTYPE );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "CreateObject error" );

        error = IOSC_ComputeSharedKey( privkeyh1, pubkeyh2, sharedkeyh1 );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "ComputeSharedKey error" );

        error = IOSC_ComputeSharedKey( privkeyh2, pubkeyh1, sharedkeyh2 );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "ComputeSharedKey error" );

        error = IOSC_ExportSecretKey( sharedkeyh1, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, sharedKey1 );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "ExportSecretKey error" );
        error = IOSC_ExportSecretKey( sharedkeyh2, 0, 0, IOSC_NOSIGN_NOENC, 0, 0, sharedKey2 );
        CHECK_EQUAL( error, IOSC_ERROR_OK, "ExportSecretKey error" );
        if( iter < 3 )
        {
            if( memcmp( (u8 *)sharedKey1, (u8 *)sharedKey2, sizeof( IOSCAesKey ) ) == 0x0 )
            {
                LOG_PASS( "IOSC ECC Shared Compare Test 1" );
            }
            else
            {
                LOG_FAIL( "IOSC ECC Shared Compare Test 1" );
                EXIT( -1 );
            }

            if( memcmp( (u8 *)sharedKey2, (u8 *)sharedKeyRef, sizeof( IOSCAesKey ) ) == 0x0 )
            {
                LOG_PASS( "IOSC ECC Shared Key Ref Test 2" );
            }
            else
            {
                LOG_FAIL( "IOSC ECC Shared Key Ref Test 2" );
                EXIT( -1 );
            }
        }
        else
        {
            /* Negative tests */
            if( memcmp( (u8 *)sharedKey1, (u8 *)sharedKey2, sizeof( IOSCAesKey ) ) == 0x0 )
            {
                LOG_FAIL( "IOSC ECC Shared Negative Test 1" );
                EXIT( -1 );
            }
            else
            {
                LOG_PASS( "IOSC ECC Shared Negative Test 1" );
            }
        }
        IOSC_DeleteObject( privkeyh1 );
        IOSC_DeleteObject( privkeyh2 );
        IOSC_DeleteObject( pubkeyh1 );
        IOSC_DeleteObject( pubkeyh2 );
        IOSC_DeleteObject( sharedkeyh1 );
        IOSC_DeleteObject( sharedkeyh2 );
    }
    return 0;
}  // NOLINT (readability/fn_size)

#if defined( SEPARATE_MAIN_PROGRAM )

int main( int argc, char **argv )
{
    IOSC_Initialize();
    doEccRefTest();
    EXIT( 0 );
    return 0;
}
#endif
