﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../../../Common/testEns_Common.h"
#include "testEns_ApiForAcbaa.h"
#include "testEns_TaskGetMessageMetadataFixture.h"
#include "testEns_TaskGetMyDesignMetadataFixture.h"

namespace nnt { namespace ens {

void GetMessageMetadataFixture(nn::ens::AsyncContext* pOutContext, nn::ens::ReceiveBuffer* pOutMetadata) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutContext);
    NN_SDK_REQUIRES_NOT_NULL(pOutMetadata);

    NN_DETAIL_ENS_CREATE_TASK(pOutContext, pTask, nnt::ens::TaskGetMessageMetadataFixture);

    pTask->SetParameter(pOutMetadata);

    nn::ens::detail::core::RegisterTask(pTask, pOutContext);
}

void GetMyDesignMetadataFixture(nn::ens::AsyncContext* pOutContext, nn::ens::ReceiveBuffer* pOutMetadata,
    const char* pDesignName) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(pOutContext);
    NN_SDK_REQUIRES_NOT_NULL(pOutMetadata);

    NN_DETAIL_ENS_CREATE_TASK(pOutContext, pTask, nnt::ens::TaskGetMyDesignMetadataFixture);

    pTask->SetParameter(pOutMetadata, pDesignName);

    nn::ens::detail::core::RegisterTask(pTask, pOutContext);
}

}}
