﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <vector>
#include <nn/nn_Macro.h>
#include <Common/DisplayConfig.h>
#include <Common/VideoConfigUtility.h>

namespace nns {

class LcdConfig : public DisplayConfig
{
private:
    struct SettingContext
    {
        struct State
        {
            const char* label;
            const float level;
        };
        typedef void (LcdConfig::*SettingFunction)(float);
        SettingFunction switchState;
        typedef const char* (LcdConfig::*StatusFunction)(void);
        StatusFunction getStatus;
        const char* caption;
        std::vector<State> state;
        int stateIndex;
    };
    std::vector<SettingContext> m_Setting;
    VideoConfigUtility m_Video;

    bool m_IsSceneSwitched;
    bool m_IsSwitchingSceneAscending;
    uint8_t m_LcdPanelId[3];
    static const int LabelStringLength = 64;
    char m_LabelString[LabelStringLength];

    void SwitchAutoBrightnessControl(float isEnabledValue) NN_NOEXCEPT;
    void SwitchCurrentBrightness(float brightness) NN_NOEXCEPT;
    void SwitchVrr(float isEnabledValue) NN_NOEXCEPT;
    void SwitchVfp(float vfpValue) NN_NOEXCEPT;
    void SwitchSceneAscending(float dummy) NN_NOEXCEPT;
    void SwitchSceneDecending(float dummy) NN_NOEXCEPT;

    const char* GetAppliedBrightness() NN_NOEXCEPT;
    const char* GetLcdPanelVendorId() NN_NOEXCEPT;

    int FindSettingStateIndexFromLevel(std::vector<SettingContext::State> settingState, int level) NN_NOEXCEPT;
    int FindSettingValueIndexFromLevel(std::vector<SettingContext::State> settingState, float level) NN_NOEXCEPT;
    float CalculateFloatMod(float value) NN_NOEXCEPT;

public:
    NN_IMPLICIT LcdConfig(bool isAutoBrightnessControl, bool isVrrEnabled,
        float brightness, int vfp, int performanceInterval) NN_NOEXCEPT;
    ~LcdConfig() NN_NOEXCEPT;
    void ApplySelectedLabel() NN_NOEXCEPT;
    int GetConfigCount() NN_NOEXCEPT;
    const char* GetConfigCaption(int index) NN_NOEXCEPT;
    const char* GetConfigStatus(int index) NN_NOEXCEPT;
    const char* GetConfigLabel(int index) NN_NOEXCEPT;
    void SetConfig(int index, bool isAscending) NN_NOEXCEPT;
    void UpdateConfig() NN_NOEXCEPT;
    bool IsSceneSwitched() NN_NOEXCEPT;
    const Color& GetBackGroundColor() NN_NOEXCEPT;
    bool IsSwitchingSceneAscending() NN_NOEXCEPT;
};

}
