﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/vi.h>
#include <nn/gfx.h>

namespace nns {

class SetupGraphics
{
private:
    class SetupGraphicsImpl;
    std::unique_ptr<SetupGraphicsImpl> m_Impl;

public:
    NN_IMPLICIT SetupGraphics() NN_NOEXCEPT;
    ~SetupGraphics() NN_NOEXCEPT;
    nn::vi::Layer* GetLayer() NN_NOEXCEPT;
    nn::gfx::Device* GetDevice() NN_NOEXCEPT;
    nn::vi::Display* GetDisplay() NN_NOEXCEPT;
};

}
