﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nnt.h>
#include "master/detail/visrv_DisplaySupport.h"

class SupportFixture : public ::testing::Test
{
public:
    SupportFixture() NN_NOEXCEPT;

    nn::visrv::master::detail::DisplaySupport GetSupport() NN_NOEXCEPT;

    static bool HasQueriedScalingModeSupport() NN_NOEXCEPT;

    static void SetScalingModeSupport(bool isSupported) NN_NOEXCEPT;
private:
    static bool g_isScalingModeSupported;
    static bool g_hasQueriedScalingModeSupport;

    static bool ScalingModeSupport(nn::vi::ScalingMode mode) NN_NOEXCEPT;
};
