﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_DisplayModeInfo.h>
#include "master/visrv_Layer.h"
#include "testDisplay_DefaultDisplayFixture.h"

DefaultDisplayFixture::DefaultDisplayFixture()
    : m_Allocator(&m_AllocationRegion, sizeof(m_AllocationRegion), NN_ALIGNOF(nn::visrv::master::Layer))
{
    nn::visrv::master::detail::PlatformDisplayInfo info("Default",
                                                        1920,
                                                        1080,
                                                        nn::visrv::master::detail::DisplayPolicy(true,
                                                                                      1,
                                                                                      0,
                                                                                      0),
                                                        nn::visrv::master::detail::DisplaySupport{ nullptr },
                                                        false);

    m_InfoSet.SetInfo(nn::vi::PolicyLevel_Standard, info);
}

const nn::visrv::master::detail::PlatformDisplayInfoSet& DefaultDisplayFixture::GetInfoSet() const NN_NOEXCEPT
{
    return m_InfoSet;
}

nn::visrv::master::Display::Allocator* DefaultDisplayFixture::GetAllocator() NN_NOEXCEPT
{
    return &m_Allocator;
}
