﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/vi.h>
#include <nnt/result/testResult_Assert.h>
#include <nnt/viUtil/testVi_Fixture.h>

typedef nnt::vi::util::Fixture LayerStress;

#ifdef NN_BUILD_CONFIG_OS_WIN32
    // SIGLO-83050: Each iteration on Windows 7 takes quite a bit more time due to
    //              training the vsync timer.
    //              Once Windows 7 isn't supported, then this can be removed.
    const int StressTestCount = 1024;
#else
    const int StressTestCount = 8192;
#endif

TEST_F(LayerStress, OpenClose_Any)
{
    nn::vi::Initialize();

    for( int i = 0; i < StressTestCount; ++i )
    {
        nn::vi::Display* pDisplay;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

        nn::vi::Layer* pLayer;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

        nn::vi::DestroyLayer(pLayer);
        nn::vi::CloseDisplay(pDisplay);
    }
}

TEST_F(LayerStress, OpenCloseDisplay_Any)
{
    nn::vi::Initialize();

    for( int i = 0; i < StressTestCount; ++i )
    {
        nn::vi::Display* pDisplay;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

        nn::vi::Layer* pLayer;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

        nn::vi::CloseDisplay(pDisplay);
    }
}

TEST_F(LayerStress, OpenFinalize_Any)
{
    for( int i = 0; i < StressTestCount; ++i )
    {
        nn::vi::Initialize();

        nn::vi::Display* pDisplay;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::OpenDefaultDisplay(&pDisplay));

        nn::vi::Layer* pLayer;
        NNT_ASSERT_RESULT_SUCCESS(nn::vi::CreateLayer(&pLayer, pDisplay));

        nn::vi::Finalize();
    }

    nn::vi::Initialize();
}
