﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt.h>
#include <nn/vi.h>
#include "vi_CommonUtility.h"

namespace
{
    const int StressCount = 8192;
}

TEST(Common, MultiInitialize_Any)
{
    for (int i = 0; i < StressCount; ++i)
    {
        nn::vi::Initialize();
        EXPECT_TRUE(nn::vi::GetService() != nullptr);
    }

    for (int i = 0; i < StressCount; ++i)
    {
        EXPECT_TRUE(nn::vi::GetService() != nullptr);
        nn::vi::Finalize();
    }

    EXPECT_EQ(nullptr, nn::vi::GetService());
}

TEST(Common, MultiFinalize_Any)
{
    for (int i = 0; i < StressCount; ++i)
    {
        EXPECT_EQ(nullptr, nn::vi::GetService());
        nn::vi::Finalize();
    }
}
