﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "testDisplay_LayerFixture.h"

LayerFixture::LayerFixture() NN_NOEXCEPT
    : m_pDisplay(nullptr)
{
}

void LayerFixture::SetUp() NN_NOEXCEPT
{
    InitializeVi();
    nn::vi::OpenDefaultDisplay(&m_pDisplay).IsSuccess();
}

void LayerFixture::TearDown() NN_NOEXCEPT
{
    if( m_pDisplay != nullptr )
    {
        nn::vi::CloseDisplay(m_pDisplay);
    }
}

nn::vi::Display* LayerFixture::GetDisplay() NN_NOEXCEPT
{
    return m_pDisplay;
}

void LayerFixture::InitializeVi() NN_NOEXCEPT
{
    nn::vi::Initialize();
}
