<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        HDCP test with Blackmagic

    .DESCRIPTION
        Verifies that HDCP doesn't work with Blackmagic and that switching between HDCP and not-HDCP works properly
#>

param
(
    [Parameter(Mandatory=$False)]
    [String]
    # The artifact path
    $ArtifactPath,
    
    [Parameter(Mandatory=$True)]
    [String]
    # The ip address of the target
    $TargetAddress
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

. "${scriptDirectoryPath}\Common.ps1"

function Dock-Undock-Test([string]$startResolution, [string]$endResolution, [string]$num)
{
    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\HDCPDisplayTest\Develop\HDCPDisplayTest.nsp" --no-wait -- -amplitude 0

    Wait-Picture-Negative "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${startResolution}_1" $LONG_WAIT

    Write-Host "Undocking..."
    & $ControlTargetExe disable-cradle

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "no_signal${startResolution}" "${num}a_" $LONG_WAIT

    Write-Host "Docking..."
    & $ControlTargetExe enable-cradle

    Wait-Picture-Negative "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_1" $LONG_WAIT
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "no_signal${startResolution}" "${num}b_" $SHORT_WAIT

    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" --no-wait

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_1" "${num}c_" $SHORT_WAIT
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_2" "${num}d_" $SHORT_WAIT
}

function Sleep-Wake-Test([string]$startResolution, [string]$endResolution, [string]$num)
{
    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\HDCPDisplayTest\Develop\HDCPDisplayTest.nsp" --no-wait -- -amplitude 0

    Wait-Picture-Negative "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${startResolution}_1" $LONG_WAIT

    Write-Host "Sleeping..."
    & $ControlTargetExe press-power-button

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "no_signal${startResolution}" "${num}a_" $LONG_WAIT

    Start-Sleep -s 10

    Write-Host "Waking..."
    & $ControlTargetPrivateExe press-power-button-for-sc7 --ip-addr $targetAddress

    & $ControlTargetExe connect

    Wait-Picture-Negative "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_1" $LONG_WAIT

    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" --no-wait

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_1" "${num}c_" $SHORT_WAIT
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_2" "${num}d_" $SHORT_WAIT
}

function System-Reset-Test([string]$startResolution, [string]$endResolution, [string]$num)
{
    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\HDCPDisplayTest\Develop\HDCPDisplayTest.nsp" --no-wait -- -amplitude 0

    Wait-Picture-Negative "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${startResolution}_1" $LONG_WAIT

    Write-Host "Restarting..."
    & $ControlTargetExe reset

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "no_signal${startResolution}" "${num}a_" $LONG_WAIT

    & $ControlTargetExe connect

    Wait-Picture-Negative "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_1" $LONG_WAIT

    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" --no-wait

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_1" "${num}c_" $SHORT_WAIT
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_2" "${num}d_" $SHORT_WAIT
}

function HDMI-Disconnect-Test([string]$startResolution, [string]$endResolution, [string]$num)
{
    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\HDCPDisplayTest\Develop\HDCPDisplayTest.nsp" --no-wait -- -amplitude 0

    Wait-Picture-Negative "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${startResolution}_1" $LONG_WAIT

    Write-Host "Disconnecting HDMI..."
    Write-HDMI-Switcher "s 2"

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "no_signal${startResolution}" "${num}a_" $LONG_WAIT

    # Note: As sending an HPD pulse is not reliable, the edid is reset instead to force a takedown/bringup
    Write-Host "Connecting HDMI and resetting EDID..."
    Write-HDMI-Switcher "s 1"
    Write-HDMI-Switcher "#set_edid output 1 input 1"

    Wait-Picture-Negative "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_1" $LONG_WAIT
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "no_signal${endResolution}" "${num}b_" $SHORT_WAIT

    $ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" --no-wait

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_1" "${num}c_" $SHORT_WAIT
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${endResolution}_2" "${num}d_" $SHORT_WAIT
}

Write-Host "Iterations: ${Iterations}"
$outputFile = "${scriptDirectoryPath}\out.png"
$startRes = 1080

Init-Transition-Test $scriptDirectoryPath $outputFile $TargetAddress

###############################################################################################
Write-Host "Running HDCP program..."

Dock-Undock-Test 1080 1080 1

Sleep-Wake-Test 1080 1080 2

System-Reset-Test 1080 1080 3

HDMI-Disconnect-Test 1080 1080 4

###############################################################################################
Write-Host "Switching between 720p and 480p for next set..."
$ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" -- -resolution 720 -update_nand -no_run

Dock-Undock-Test 1080 720 5

$ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" -- -resolution 480 -update_nand -no_run

Sleep-Wake-Test 720 480 6

$ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" -- -resolution 720 -update_nand -no_run

System-Reset-Test 480 720 7

$ret = & $RunOnTargetExe "${scriptRootPath}\Tests\Outputs\NX-NXFP2-a64\Tests\DisplayResolution\Develop\DisplayResolution.nsp" -- -resolution 480 -update_nand -no_run

HDMI-Disconnect-Test 720 480 8

###############################################################################################

Cleanup-Transition-Test $scriptDirectoryPath

###############################################################################################
if ($failure)
{
    Write-Host "FAILURES OCCURRED"
    exit 1
}

Write-Host "Passed!"
exit 0
