<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        HDMI dock-undock test (SDEV only)

    .DESCRIPTION
        Verifies the HDMI works properly following dock-undock.
#>

. "${scriptDirectoryPath}\Common.ps1"


function Transition-Loop([string]$curIteration, [string]$scriptDirectoryPath, [string]$outputFile, [string]$resolution, [string]$targetAddress)
{
    Write-Host "Undocking..."
    & $ControlTargetExe disable-cradle

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "no_signal${resolution}" "${curIteration}_" $LONG_WAIT

    Write-Host "Docking..."
    & $ControlTargetExe enable-cradle

    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${resolution}_1" "${curIteration}a_" $LONG_WAIT
    Wait-Picture "${scriptDirectoryPath}" "${outputFile}" "disp_resolution${resolution}_2" "${curIteration}b_" $SHORT_WAIT
}
