﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <windows.h>

namespace PNGHelper
{

// Writes out a PNG file
HRESULT WritePNG(const char* pFile, int width, int height, int size, BYTE* pData);

// Copies an 8-bit YUY bitmap into a phase 1 (pre-compression) PNG
void Convert8BitYUVtoPhase1(BYTE* bytes, int width, int height, BYTE** out, int* outSize);

// Copies a 32-bit BGRA bitmap into a phase 1 (pre-compression) PNG
void ConvertBGRAtoPhase1(BYTE* bytes, int width, int height, BYTE** out, int* outSize);

// Performs phase 2 (compression stage) to make a PNG
size_t CompressPhase1ToPhase2(void* pDst, size_t dstSize, const void* pSrc, size_t srcSize);

}
