﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <windows.h>
#include <cstdio>
#include <cstdlib>
#include <string>

#include "CaptureHelper.h"
#include "CommandList.h"

#define WM_USER_TAKE_PICTURE (WM_USER + 1)

// Handles any active arguments (e.g. TakePicture, CaptureStream)
bool HandleActiveArguments(int argc, char** argv)
{
    // Keep track of and return whether there were any active arguments (the program keeps running if there were none)
    bool activeArgument = false;

    for (int i = 1; i < argc; ++i)
    {
        if (!_stricmp(argv[i], "-TakePicture"))
        {
            printf("Taking picture...\n");
            TakePicture(nullptr);

            activeArgument = true;
            continue;
        }
        if (!_stricmp(argv[i], "-CaptureStream"))
        {
            if (i + 1 >= argc)
            {
                printf("Error: expected number of frames after -CaptureStream\n");
                return true;
            }

            ++i;
            int captureStreamFrames = atoi(argv[i]);

            printf("Capturing stream for %i frames...\n", captureStreamFrames);

            CaptureStream(captureStreamFrames, nullptr);

            activeArgument = true;
            continue;
        }
    }

    return activeArgument;
}

int main(int argc, char** argv)
{
    CaptureHelper::Init(argc, argv);

    std::string outputFile = CaptureHelper::GetOutputFile();

    // If there weren't any active arguments (or errors), keep running
    if (!HandleActiveArguments(argc, argv))
    {
        MSG message;
        while (GetMessage(&message, nullptr, 0, 0))
        {
            switch (message.message)
            {
            case WM_USER_TAKE_PICTURE:
                printf("Taking picture...\n");
                TakePicture("temp.png");
                MoveFileA("temp.png", outputFile.c_str());
                break;
            default:
                break;
            }

            Sleep(10);
        }
    }

    return 0;
}
