﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DecklinkBase.h"

struct DecklinkInterface : public DecklinkBase
{
    DecklinkInterface(int index, int (*printFunc)(const char* format, va_list args) = vprintf, void (*errorHandler)(void) = DefaultErrorHandler);
    ~DecklinkInterface();

    DecklinkInterface(const DecklinkInterface&) = delete;
    const DecklinkInterface& operator=(const DecklinkInterface&) = delete;

    void StartCapture();
    void StopCapture();

    typedef void (*PreviewHandlerFunc)(unsigned char* videoBytes, int videoWidth, int videoHeight, BMDPixelFormat pixelFormat);
    typedef void (*VideoHandlerFunc)(unsigned char* videoBytes, int videoWidth, int videoHeight, BMDPixelFormat pixelFormat,
                                     unsigned char* audioBytes, int audioFrameCount,
                                     bool droppedFrames);

    void SetPreviewHandler(PreviewHandlerFunc func);
    void SetVideoHandler(VideoHandlerFunc func);

    void SetAudioChannels(int channels);
    void SetAudioSampleDepth(int depth);
    void SetAudioBitrate(int rate);

    int GetAudioSampleSize();
    int GetAudioChannels();
    int GetAudioSampleDepth();
    int GetAudioBitrate();

private:

    // The default is just printf/exit/do nothing
    void Print(const char* format, ...);
    static void DefaultErrorHandler() { exit(-1); }

    void Reset(BMDDisplayMode displayMode, BMDPixelFormat BMDPixelFormat);
    void GotPreview(IDeckLinkVideoFrame* videoFrame);
    void GotVideo(IDeckLinkVideoInputFrame* videoFrame, IDeckLinkAudioInputPacket* audioFrame);

    void VerifyInactive(const char* location);

    PreviewHandlerFunc              m_previewHandler;
    VideoHandlerFunc                m_videoHandler;

    void (*m_errorHandler)(void);
    int (*m_printf)(const char* format, va_list args);

    IDeckLinkInput*                 m_pDeckLinkInput;

    DecklinkPreviewCallback         m_previewCallback;
    DecklinkInputCallback           m_inputCallback;

    BMDTimeScale                    m_oldFrameTime;

    int                             m_audioChannels;
    BMDAudioSampleType              m_audioSampleType;
    int                             m_audioSampleDepth;

    int                             m_AudioBitrate;
    BMDAudioSampleRate              m_AudioSampleRate;

    bool                            m_captureEnabled;

    friend DecklinkPreviewCallback;
    friend DecklinkInputCallback;
};
