﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TargetUtility
{
    class LogServer
    {
        private const string processName = "Nintendo Log Server";

        public static void Boot()
        {
            using (var process = new Process())
            {
                process.StartInfo.FileName = EnvironmentInfo.LogServer;
                process.StartInfo.UseShellExecute = false;
                process.Start();
            }
        }

        public static void Shutdown()
        {
            TimeSpan timeout = TimeSpan.FromSeconds(5);

            var process = Process.GetProcessesByName(processName).FirstOrDefault();
            if (process != null)
            {
                process.CloseMainWindow();
                if (!process.WaitForExit((int)timeout.TotalMilliseconds))
                {
                    process.Kill();
                }
            }
        }

        public static void Kill()
        {
            Process.GetProcessesByName(processName).FirstOrDefault()?.Kill();
        }

        public static void Reboot()
        {
            Shutdown();
            Boot();
        }
    }
}
