﻿using System;

namespace TargetUtility
{
    class Builder
    {
        public static void BuildTools()
        {
            TimeSpan timeout = TimeSpan.FromMinutes(5);

            string option =
                $@" -d {EnvironmentInfo.NintendoSdkRoot}\Programs\Chris\Sources\Tools\RunnerTools";

            var result = Runner.RunApplication(
                EnvironmentInfo.Nact, option, timeout);
            if (result.ExitCode != 0)
            {
                throw new Exception(
                    $"Failed to build firmware\n" +
                    $"ExitCode={result.ExitCode}\n" +
                    $"Output=\n{result.MixedOutputString}");
            }
        }

        public static void BuildFirmware()
        {
            TimeSpan timeout = TimeSpan.FromMinutes(15);

            string option =
                @"specs=NX platforms=NXFP2-a64" +
                @" -F ""NX-K.-Hb-Unsigned-Nand-64G-Internal\.initimg""" +
                @" -F ""RecoveryWriter-K.-Hb-Unsigned\.qspi\.img""" +
                @" -F ""SystemUpdaterHostFs\.nca""" +
                @" -F ""HelloWorld\.nca""";

            var result = Runner.RunApplication(
                EnvironmentInfo.Nact, option, timeout);
            if (result.ExitCode != 0)
            {
                throw new Exception(
                    $"Failed to build firmware\n" +
                    $"ExitCode={result.ExitCode}\n" +
                    $"Output=\n{result.MixedOutputString}");
            }
        }
    }
}
