﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/diag/detail/diag_DetailTranslation.h>

#include "testDiag_Translation.dictionary.h"

// CP932 外の文字を使った際に、コンパイル警告が出ないことを確かめるテスト
TEST(TranslationTest, OutOfCp932)
{
    // 辞書を検索
    NN_SDK_TEXT_TESTDIAG("가\n");
}

// ワイド文字列 -> UTF-8 の変換結果がキャッシュされることを確かめるテスト
TEST(TranslationTest, Cache)
{
    // キャッシュされていれば同じポインタが返ってくるはず
    ASSERT_EQ(NN_SDK_TEXT_TESTDIAG("a"), NN_SDK_TEXT_TESTDIAG("a"));
}

