﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nnt/nntest.h>
#include <nn/diag/diag_AssertionFailureHandler.h>
#include "testDiag_AssertTestUtil.h"

namespace
{
    bool g_CustomHandlerIsCalled;
    nn::diag::AssertionType g_AssertionType;
}

nn::diag::AssertionFailureOperation ContinuingAssertionFailureHandler(
    const nn::diag::AssertionInfo& assertionInfo)
{
    g_CustomHandlerIsCalled = true;
    g_AssertionType = assertionInfo.assertionType;
    return nn::diag::AssertionFailureOperation_Continue;
}

nn::diag::AssertionFailureOperation AbortingAssertionFailureHandler(
    const nn::diag::AssertionInfo&)
{
    return nn::diag::AssertionFailureOperation_Abort;
}

void ClearCustomHandlerCalled()
{
    g_CustomHandlerIsCalled = false;
}

bool IsCustomHandlerCalled()
{
    return g_CustomHandlerIsCalled;
}

nn::diag::AssertionType GetLastAssertionType()
{
    return g_AssertionType;
}

ScopedSetAssertionFailureHandler::ScopedSetAssertionFailureHandler(nn::diag::AssertionFailureHandler handler)
{
    nn::diag::SetAssertionFailureHandler(handler);
}

ScopedSetAssertionFailureHandler::~ScopedSetAssertionFailureHandler()
{
    nn::diag::SetAssertionFailureHandler(AbortingAssertionFailureHandler);
}
