﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cmath>
#include <nn/cstd/cstd_CMath.h>

#include <limits>
#include <nn/nn_Common.h>
#include <nnt/nntest.h>

TEST(Math, TestIsNan)
{
    EXPECT_FALSE(nn::cstd::IsNan(std::numeric_limits<long double>::infinity()));
    EXPECT_FALSE(nn::cstd::IsNan(std::numeric_limits<double>::infinity()));
    EXPECT_FALSE(nn::cstd::IsNan(std::numeric_limits<float>::infinity()));
    EXPECT_FALSE(nn::cstd::IsNan(-std::numeric_limits<long double>::infinity()));
    EXPECT_FALSE(nn::cstd::IsNan(-std::numeric_limits<double>::infinity()));
    EXPECT_FALSE(nn::cstd::IsNan(-std::numeric_limits<float>::infinity()));
    EXPECT_TRUE (nn::cstd::IsNan(std::numeric_limits<long double>::quiet_NaN()));
    EXPECT_TRUE (nn::cstd::IsNan(std::numeric_limits<double>::quiet_NaN()));
    EXPECT_TRUE (nn::cstd::IsNan(std::numeric_limits<float>::quiet_NaN()));
    EXPECT_TRUE (nn::cstd::IsNan(std::numeric_limits<long double>::signaling_NaN()));
    EXPECT_TRUE (nn::cstd::IsNan(std::numeric_limits<double>::signaling_NaN()));
    EXPECT_TRUE (nn::cstd::IsNan(std::numeric_limits<float>::signaling_NaN()));
    EXPECT_FALSE(nn::cstd::IsNan(std::numeric_limits<long double>::max()));
    EXPECT_FALSE(nn::cstd::IsNan(std::numeric_limits<double>::max()));
    EXPECT_FALSE(nn::cstd::IsNan(std::numeric_limits<float>::max()));
    EXPECT_FALSE(nn::cstd::IsNan(std::numeric_limits<long double>::min()));
    EXPECT_FALSE(nn::cstd::IsNan(std::numeric_limits<double>::min()));
    EXPECT_FALSE(nn::cstd::IsNan(std::numeric_limits<float>::min()));
    EXPECT_FALSE(nn::cstd::IsNan(0.L));
    EXPECT_FALSE(nn::cstd::IsNan(0.));
    EXPECT_FALSE(nn::cstd::IsNan(0.f));
}

TEST(Math, TestIsInf)
{
    EXPECT_TRUE (nn::cstd::IsInf(std::numeric_limits<long double>::infinity()));
    EXPECT_TRUE (nn::cstd::IsInf(std::numeric_limits<double>::infinity()));
    EXPECT_TRUE (nn::cstd::IsInf(std::numeric_limits<float>::infinity()));
    EXPECT_TRUE (nn::cstd::IsInf(-std::numeric_limits<long double>::infinity()));
    EXPECT_TRUE (nn::cstd::IsInf(-std::numeric_limits<double>::infinity()));
    EXPECT_TRUE (nn::cstd::IsInf(-std::numeric_limits<float>::infinity()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<long double>::quiet_NaN()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<double>::quiet_NaN()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<float>::quiet_NaN()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<long double>::signaling_NaN()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<double>::signaling_NaN()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<float>::signaling_NaN()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<long double>::max()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<double>::max()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<float>::max()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<long double>::min()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<double>::min()));
    EXPECT_FALSE(nn::cstd::IsInf(std::numeric_limits<float>::min()));
    EXPECT_FALSE(nn::cstd::IsInf(0.L));
    EXPECT_FALSE(nn::cstd::IsInf(0.));
    EXPECT_FALSE(nn::cstd::IsInf(0.f));
}
