﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/crypto.h>
#include <nn/crypto/crypto_Aes128CmacGenerator.h>

#include <nnt/nntest.h>

/*
  計測ケースの追加手順

  (1) 各 Mac 用のインターフェースを持つクラスを用意する

  (2) TeamCity のプロット用の文字列を返すインターフェースを用意する
      const char* GetName()

  (3) パフォーマンスチェック用に以下の定数を定義（定義の実体は testCrypto_PerformanceTarget.cpp に記載）
      static const uint64_t TargetPerformance

  (4) typedef ::testing::Types<*> MacTypes;
      の行の <> の中に上記のクラス名を追加する
 */


// AES-CMAC
class AesCmacGenerator : public nn::crypto::Aes128CmacGenerator
{
public:
    static const uint64_t TargetPerformance;

public:
    const char* GetName()
    {
        return "AES-128-CMAC";
    }
};

// AES-GMAC（参考）
class AesGmacGenerator
{
public:
    static const uint64_t TargetPerformance;
    static const size_t MacSize = 16;

public:
    void Initialize(const void* pKey, size_t keySize) NN_NOEXCEPT
    {
        uint8_t testIv[16] = {0};

        m_AesGmacGenerator.Initialize(pKey, keySize, testIv, sizeof(testIv));
    }

    void Update(const void* pData, size_t dataSize) NN_NOEXCEPT
    {
        m_AesGmacGenerator.UpdateAad(pData, dataSize);
    }

    void GetMac(void* pMac, size_t macSize) NN_NOEXCEPT
    {
        m_AesGmacGenerator.GetMac(pMac, macSize);
    }

    const char* GetName()
    {
        return "AES-128-GMAC";
    }

private:
    nn::crypto::Aes128GcmEncryptor m_AesGmacGenerator;
};

/**
  @brief  実装クラスを定義した型です。
 */
typedef ::testing::Types<AesCmacGenerator, AesGmacGenerator> MacTypes;

