﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/nntest.h>
#include <nn/crypto/detail/crypto_BigNum.h>

TEST(BigNumTest, AddSubMod)
{
    nn::crypto::detail::BigNum::Digit mod = 47;
    nn::crypto::detail::BigNum::Digit a = 40;
    nn::crypto::detail::BigNum::Digit b = 7;

    nn::crypto::detail::BigNum::Digit res = 0;
    nn::crypto::detail::BigNum::AddMod( &res, &a, &b, &mod, 1);
    EXPECT_EQ(0, res);

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
    // Calling res = (a - b) mod c where a >= c
    nn::crypto::detail::BigNum::Digit z = 0;
    EXPECT_DEATH_IF_SUPPORTED( nn::crypto::detail::BigNum::SubMod(&res, &mod, &z, &mod, 1), "" );
#endif
}

