﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/crypto/crypto_Aes128GcmDecryptor.h>
#include <nn/crypto/crypto_Aes128GcmEncryptor.h>
#include <cstring>

#include <nnt/nntest.h>
#include "GcmParser.h"
#include "ProfileCheck.h"
#include "OctetString.h"


TEST(Aes256Gcm, Encrypt256_rsp)
{
    GcmEncryptParser<nn::crypto::AesEncryptor256> tester;
    tester.TestFile("aes_gcm/gcmtestvectors/gcmEncryptExtIV256.rsp", 7875);
}

TEST(Aes256Gcm, Decrypt256_rsp)
{
    GcmDecryptParser<nn::crypto::AesEncryptor256> tester;
    tester.TestFile("aes_gcm/gcmtestvectors/gcmDecrypt256.rsp", 7875);
}
