﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/graphics/testGraphics_CreateDirectories.h>

#include <nn/fs.h>
#include <nnt/graphics/testGraphics_Path.h>

namespace nnt{ namespace graphics{

    nn::Result CreateDirectories(const char* path)
    {
        Path p(path);
        return CreateDirectories(&p);
    }
    nn::Result CreateDirectories(const Path& path)
    {
        return CreateDirectories(path.GetString());
    }

    nn::Result CreateDirectories(const Path* path)
    {
        // ルートだったら何もしない
        if(path->IsRoot())
        {
            return nn::ResultSuccess();
        }
        // ディレクトリを作ろうとしてみる
        nn::Result result = nn::fs::CreateDirectory(path->GetString());
        // 成功
        if(result.IsSuccess())
        {
            return nn::ResultSuccess();
        }
        // 既に存在していたら、ディレクトリか確認
        else if(nn::fs::ResultPathAlreadyExists::Includes(result))
        {
            nn::fs::DirectoryEntryType type;
            result = nn::fs::GetEntryType(&type, path->GetString());
            if(!result.IsSuccess())
            {
                // エラーとしては nn::fs::CreateDirectory() の戻り値を返しておく
                return nn::fs::ResultPathAlreadyExists();
            }
            if(type != nn::fs::DirectoryEntryType::DirectoryEntryType_Directory)
            {
                return nn::fs::ResultPathAlreadyExists();
            }
            return nn::ResultSuccess();
        }
        // 親ディレクトリが見つからなければ親を作る
        else if(nn::fs::ResultPathNotFound::Includes(result))
        {
            Path parent;
            path->GetParent(&parent);
            result = CreateDirectories(&parent);
            if(!result.IsSuccess())
            {
                return result;
            }
            result = nn::fs::CreateDirectory(path->GetString());
            return result;
        }
        // それ以外なら失敗
        else
        {
            return result;
        }
    }

}}
