﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/gfx/testGfx_Compare.h>

namespace nnt {
namespace gfx {

//---------------------------------------------------------------------------
//  誤差を許容したバッファの比較処理
//---------------------------------------------------------------------------
bool NntGfxCompare::Compare( const uint8_t* src, size_t srcSize, const uint8_t* org, size_t orgSize, bool& result, uint8_t* dst, int diffVal, bool errorColorRed )
{
    if( src == NULL || org == NULL )
    {
        return false;
    }

    if( srcSize != orgSize )
    {
        return false;
    }

    bool diff = false;
    if ( dst != NULL)
    {
        diff = true;
    }

    result = true;
    if (!errorColorRed)
    {
        for( size_t i = 0; i < orgSize; ++i )
        {
            int error = abs( src[ i ] - org[ i ] );

            if( !diff || error < diffVal )
            {
                continue;
            }

            dst[ i ] = static_cast<uint8_t>(error);

            result = false;
        }
    }
    else
    {
        for( size_t i = 0; i < orgSize; i+=3 )
        {
            int error = abs( src[ i ] - org[ i ] );
            error += abs( src[ i + 1 ] - org[ i + 1 ] );
            error += abs( src[ i + 2 ] - org[ i + 2 ] );

            if( !diff || error < diffVal )
            {
                continue;
            }

            dst[ i     ] = static_cast<uint8_t>(255);
            dst[ i + 1 ] = 0;
            dst[ i + 2 ] = 0;

            result = false;
        }
    }

    return true;
}

}
}
