﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Fx3Control/Fx3Control.h"

namespace nnt {
namespace usb {
namespace cdmsc {

extern bool g_DownloadFirmware;

TEST(Fx3MscTestSuite, Enumeration0_0)
{
    nn::cdmsc::UnitProfile profile;

    Fx3Reset(WAIT_SECONDS_FOR_ATTACH, g_DownloadFirmware);

    Fx3ActivateMassStorageMode(WAIT_SECONDS_FOR_ATTACH);
    NNT_EXPECT_RESULT_SUCCESS(Fx3Probe(&profile));

    FX3_LOG("Vid: %d, PID:%d\n", profile.vid, profile.pid);
}


} // cdmsc
} // usb
} // nnt
