﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Fx3Control/Fx3Control.h"

namespace nnt {
namespace usb {
namespace cdmsc {

extern bool g_DownloadFirmware;

TEST(Fx3MscTestSuite, GetMaxLun1_1)
{
    nn::cdmsc::UnitProfile profile;
    uint16_t commandInfo = 0;
    NN_USB_DMA_ALIGN uint32_t maxLunValue = 0;

    Fx3Reset(WAIT_SECONDS_FOR_ATTACH, g_DownloadFirmware);

    commandInfo = Fx3TestField_GetMaxLun;

    Fx3SendVendorSpecificRequest(
        (uint8_t*)&maxLunValue,
        0x40,
        Fx3Request_SetFieldValue,
        commandInfo,
        0x00,
        sizeof(maxLunValue)
    );

    Fx3ActivateMassStorageMode(WAIT_SECONDS_FOR_ATTACH);
    NNT_EXPECT_RESULT_SUCCESS(Fx3Probe(&profile));

    FX3_LOG("Vid: %d, PID:%d\n", profile.vid, profile.pid);
}


TEST(Fx3MscTestSuite, GetMaxLun1_2)
{
    nn::cdmsc::UnitProfile profile;
    uint16_t commandInfo = 0;
    NN_USB_DMA_ALIGN Fx3TestResponse testResponse = { 0 };

    Fx3Reset(WAIT_SECONDS_FOR_ATTACH, g_DownloadFirmware);

    commandInfo = Fx3MscCommand_GetMaxLun << 8;

    testResponse.Type = Fx3MscTestResponseType_StallNumberOfTimes;
    testResponse.u.StallCount.Count = 1;

    Fx3SendVendorSpecificRequest(
        (uint8_t*)&testResponse,
        0x40,
        Fx3Request_SetTestResponse,
        commandInfo,
        0x00,
        sizeof(testResponse)
    );

    Fx3ActivateMassStorageMode(WAIT_SECONDS_FOR_ATTACH);
    NNT_EXPECT_RESULT_SUCCESS(Fx3Probe(&profile));

    FX3_LOG("Vid: %d, PID:%d\n", profile.vid, profile.pid);
}


TEST(Fx3MscTestSuite, GetMaxLun1_3)
{
    nn::cdmsc::UnitProfile profile;
    uint16_t commandInfo = 0;
    NN_USB_DMA_ALIGN uint32_t maxLunValue = 1;

    Fx3Reset(WAIT_SECONDS_FOR_ATTACH, g_DownloadFirmware);

    commandInfo = Fx3TestField_GetMaxLun;

    Fx3SendVendorSpecificRequest(
        (uint8_t*)&maxLunValue,
        0x40,
        Fx3Request_SetFieldValue,
        commandInfo,
        0x00,
        sizeof(maxLunValue)
    );

    Fx3ActivateMassStorageMode(WAIT_SECONDS_FOR_ATTACH);
    NNT_EXPECT_RESULT_SUCCESS(Fx3Probe(&profile));

    FX3_LOG("Vid: %d, PID:%d\n", profile.vid, profile.pid);
}


TEST(Fx3MscTestSuite, GetMaxLun1_4)
{
    nn::cdmsc::UnitProfile profile;
    uint16_t commandInfo = 0;
    NN_USB_DMA_ALIGN uint32_t maxLunValue = 0x0F;

    Fx3Reset(WAIT_SECONDS_FOR_ATTACH, g_DownloadFirmware);

    commandInfo = Fx3TestField_GetMaxLun;

    Fx3SendVendorSpecificRequest(
        (uint8_t*)&maxLunValue,
        0x40,
        Fx3Request_SetFieldValue,
        commandInfo,
        0x00,
        sizeof(maxLunValue)
    );

    Fx3ActivateMassStorageMode(WAIT_SECONDS_FOR_ATTACH);
    NNT_EXPECT_RESULT_SUCCESS(Fx3Probe(&profile));

    FX3_LOG("Vid: %d, PID:%d\n", profile.vid, profile.pid);
}


TEST(Fx3MscTestSuite, GetMaxLun1_5)
{
    nn::cdmsc::UnitProfile profile;
    uint16_t commandInfo = 0;
    uint16_t setMaxLunCount = 10;
    NN_USB_DMA_ALIGN uint32_t maxLunValue = 0x10;
    NN_USB_DMA_ALIGN uint8_t readLogData[Fx3CommandLogLength] = { 0 };
    uint16_t logType = 0;
    int logIndex = 0;
    int getMaxLunCount = 0;

    Fx3Reset(WAIT_SECONDS_FOR_ATTACH, g_DownloadFirmware);

    commandInfo = Fx3TestField_GetMaxLun;

    Fx3SendVendorSpecificRequest(
        (uint8_t*)&maxLunValue,
        0x40,
        Fx3Request_SetFieldValue,
        commandInfo,
        setMaxLunCount,
        sizeof(maxLunValue)
    );

    // clear command logs
    logType = Fx3ClearCommandLog << 8;

    Fx3SendVendorSpecificRequest(
        nullptr,
        0x40,
        Fx3Request_ClearLog,
        logType,
        0x00,
        0x00
    );

    Fx3ActivateMassStorageMode(WAIT_SECONDS_FOR_ATTACH);

    NNT_EXPECT_RESULT_SUCCESS(Fx3Probe(&profile));

    Fx3SendVendorSpecificRequest(
        readLogData,
        0xC0,
        Fx3Request_GetCommandLog,
        0x00,
        0x00,
        Fx3CommandLogLength
    );

    for (logIndex = 0; logIndex < Fx3CommandLogLength; logIndex++)
    {
        if (readLogData[logIndex] == Fx3MscCommand_GetMaxLun)
        {
            getMaxLunCount++;
        }
    }

    EXPECT_EQ(setMaxLunCount + 1, getMaxLunCount);

}


} // cdmsc
} // usb
} // nnt
