﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdlib>


static void MakeGaloisPattern(uint8_t* pData, uint32_t size, uint32_t initialCondition)
{
    // NN_LOG("MakeGaloisPattern wtih initial condition %d\n", initialCondition);
    uint32_t processed;
    uint32_t lfsr = initialCondition;
    for (processed = 0; processed < size; processed += 4) {
        uint32_t remaining = size - processed;
        /* taps: 32 31 29 1; characteristic polynomial: x^32 + x^31 + x^29 + x + 1 */
        lfsr = (lfsr >> 1) ^ (uint32_t)((0 - (lfsr & 1u)) & 0xd0000001u);
        /* we cannot always have 32-bit alignment in buffer, so it's best
           to memcpy */
        memcpy(pData + processed, &lfsr, (remaining >= 4) ? 4 : remaining);
    }
}

static bool CheckGaloisPattern(uint8_t* pData, uint32_t size, uint32_t initialCondition)
{
    // NN_LOG("CheckGaloisPattern wtih initial condition %d\n", initialCondition);
    uint32_t processed;
    uint32_t lfsr = initialCondition;
    bool success = true;
    int maxFails = 8;
    for (processed = 0; processed < size; processed += 4) {
        uint32_t remaining = size - processed;
        /* taps: 32 31 29 1; characteristic polynomial: x^32 + x^31 + x^29 + x + 1 */
        lfsr = (lfsr >> 1) ^ (uint32_t)((0 - (lfsr & 1u)) & 0xd0000001u);
        /* we cannot always have 32-bit alignment in buffer, so it's best
           to memcmp */
        if (memcmp(pData + processed, &lfsr, (remaining >= 4) ? 4 : remaining) != 0) {
            success = false;
            NN_LOG("Error at Offset %d: Expected 0x%x, had 0x%x \n", processed, lfsr, *(uint32_t *)(pData + processed));
            if(maxFails-- == 0)
            {
                NN_LOG("Too Many Errors - aborting.\n");
                break;
            }
        }
    }
    return success;
}
